/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.formatter.base;

import java.io.PrintWriter;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.Column;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.Identifiers;
import schemacrawler.schema.IdentifiersBuilder;
import schemacrawler.schema.IndexColumn;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Table;
import schemacrawler.tools.command.text.schema.options.SchemaTextDetailType;
import schemacrawler.tools.command.text.schema.options.TextOutputFormat;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.formatter.base.helper.HtmlFormattingHelper;
import schemacrawler.tools.text.formatter.base.helper.PlainTextFormattingHelper;
import schemacrawler.tools.text.formatter.base.helper.TextFormattingHelper;
import schemacrawler.tools.text.options.BaseTextOptions;
import schemacrawler.tools.text.options.DatabaseObjectColorMap;
import schemacrawler.tools.traversal.TraversalHandler;
import schemacrawler.utility.MetaDataUtility;
import us.fatehi.utility.Utility;

public abstract class BaseFormatter<O extends BaseTextOptions>
implements TraversalHandler {
    private static final Logger LOGGER = Logger.getLogger(BaseFormatter.class.getName());
    protected final O options;
    protected final SchemaTextDetailType schemaTextDetailType;
    protected final OutputOptions outputOptions;
    protected final TextFormattingHelper formattingHelper;
    protected final DatabaseObjectColorMap colorMap;
    protected final Identifiers identifiers;
    private final PrintWriter out;

    protected BaseFormatter(SchemaTextDetailType schemaTextDetailType, O options, OutputOptions outputOptions, Identifiers identifiers) {
        this.options = (BaseTextOptions)Objects.requireNonNull(options, "Options not provided");
        this.schemaTextDetailType = Objects.requireNonNull(schemaTextDetailType, "SchemaTextDetailType not provided");
        this.outputOptions = Objects.requireNonNull(outputOptions, "Output options not provided");
        this.colorMap = ((BaseTextOptions)options).getColorMap();
        IdentifiersBuilder identifiersBuilder = IdentifiersBuilder.builder().fromOptions(identifiers).withIdentifierQuotingStrategy(((BaseTextOptions)options).getIdentifierQuotingStrategy());
        this.identifiers = identifiersBuilder.toOptions();
        this.out = outputOptions.openNewOutputWriter(false);
        TextOutputFormat outputFormat = TextOutputFormat.fromFormat(outputOptions.getOutputFormatValue());
        switch (outputFormat) {
            case html: {
                this.formattingHelper = new HtmlFormattingHelper(this.out, outputFormat);
                break;
            }
            default: {
                this.formattingHelper = new PlainTextFormattingHelper(this.out, outputFormat);
            }
        }
    }

    @Override
    public void end() {
        LOGGER.log(Level.INFO, "Closing writer");
        this.out.flush();
        this.out.close();
    }

    protected String columnNullable(String columnTypeName, boolean isNullable) {
        String columnNullable = isNullable ? "" : (Utility.hasNoUpperCase((String)columnTypeName) ? " not null" : " NOT NULL");
        return columnNullable;
    }

    protected boolean isBrief() {
        return this.schemaTextDetailType == SchemaTextDetailType.brief;
    }

    protected boolean isColumnSignificant(Column column) {
        if (column == null) {
            return false;
        }
        if (!this.isBrief()) {
            return true;
        }
        return column instanceof IndexColumn || column.isSignificant();
    }

    protected boolean isTableFiltered(Table table) {
        return (Boolean)table.getAttribute("schemacrawler.filtered_out", (Object)false) != false || MetaDataUtility.isPartial((DatabaseObject)table);
    }

    protected boolean isVerbose() {
        return this.schemaTextDetailType == SchemaTextDetailType.details;
    }

    protected String nodeId(DatabaseObject dbObject) {
        if (dbObject == null) {
            return "";
        }
        return dbObject.key().slug();
    }

    protected String quoteName(DatabaseObject table) {
        String tableName = ((BaseTextOptions)this.options).isShowUnqualifiedNames() ? this.identifiers.quoteName((NamedObject)table) : this.identifiers.quoteFullName(table);
        return tableName;
    }
}

