/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ml.tools.model.pipeline;

import com.jetbrains.ml.api.feature.Feature;
import com.jetbrains.ml.api.feature.FeatureSet;
import com.jetbrains.ml.api.feature.preprocessor.FeaturePreprocessor;
import com.jetbrains.ml.tools.data.DataFrame;
import com.jetbrains.ml.tools.model.ClassesProbabilities;
import com.jetbrains.ml.tools.model.Logit;
import com.jetbrains.ml.tools.model.MLModel;
import com.jetbrains.ml.tools.model.Probability;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00030\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\b\u0012\u0004\u0012\u0002H\u00030\u0002B+\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010 H\u0016J0\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00010\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0 2\u0012\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0 0\"H\u0014J\u001b\u0010&\u001a\u00028\u00012\f\u0010'\u001a\b\u0012\u0004\u0012\u00020$0 H\u0014\u00a2\u0006\u0002\u0010(J'\u0010)\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H*0\u0002\u0012\u0004\u0012\u0002H*0\u0000\"\n\b\u0002\u0010*\u0018\u0001*\u00020\u0004H\u0086\bJ\u0018\u0010+\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0\u0002\u0012\u0004\u0012\u00020,0\u0000J\u0018\u0010-\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020.0\u0002\u0012\u0004\u0012\u00020.0\u0000J\u0018\u0010/\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002000\u0002\u0012\u0004\u0012\u0002000\u0000R\u0013\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0011\u001a\u00020\u00128VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00061"}, d2={"Lcom/jetbrains/ml/tools/model/pipeline/ModelPipeline;", "M", "Lcom/jetbrains/ml/tools/model/MLModel;", "P", "", "preprocessing", "Lcom/jetbrains/ml/api/feature/preprocessor/FeaturePreprocessor;", "baseModel", "info", "", "", "(Lcom/jetbrains/ml/api/feature/preprocessor/FeaturePreprocessor;Lcom/jetbrains/ml/tools/model/MLModel;Ljava/util/Map;)V", "getBaseModel", "()Lcom/jetbrains/ml/tools/model/MLModel;", "Lcom/jetbrains/ml/tools/model/MLModel;", "getInfo", "()Ljava/util/Map;", "inputFeatures", "Lcom/jetbrains/ml/api/feature/FeatureSet;", "getInputFeatures", "()Lcom/jetbrains/ml/api/feature/FeatureSet;", "inputFeatures$delegate", "Lkotlin/Lazy;", "predictedType", "Ljava/lang/Class;", "getPredictedType", "()Ljava/lang/Class;", "getPreprocessing", "()Lcom/jetbrains/ml/api/feature/preprocessor/FeaturePreprocessor;", "buildPredictionsDataFrame", "Lcom/jetbrains/ml/tools/data/DataFrame;", "predictions", "", "predictBatchWithInputFeatures", "", "contextFeatures", "Lcom/jetbrains/ml/api/feature/Feature;", "itemFeatures", "predictWithInputFeatures", "features", "(Ljava/util/Collection;)Ljava/lang/Object;", "predicting", "T", "predictingClasses", "Lcom/jetbrains/ml/tools/model/ClassesProbabilities;", "predictingLogit", "Lcom/jetbrains/ml/tools/model/Logit;", "predictingProbability", "Lcom/jetbrains/ml/tools/model/Probability;", "ml-tools"})
@SourceDebugExtension(value={"SMAP\nModelPipeline.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelPipeline.kt\ncom/jetbrains/ml/tools/model/pipeline/ModelPipeline\n*L\n1#1,90:1\n55#1,5:91\n55#1,5:96\n55#1,5:101\n*S KotlinDebug\n*F\n+ 1 ModelPipeline.kt\ncom/jetbrains/ml/tools/model/pipeline/ModelPipeline\n*L\n63#1:91,5\n65#1:96,5\n67#1:101,5\n*E\n"})
public final class ModelPipeline<M extends MLModel<? extends P>, P>
extends MLModel<P> {
    @Nullable
    private final FeaturePreprocessor preprocessing;
    @NotNull
    private final M baseModel;
    @NotNull
    private final Map<String, Object> info;
    @NotNull
    private final Lazy inputFeatures$delegate;
    @NotNull
    private final Class<? extends P> predictedType;

    public ModelPipeline(@Nullable FeaturePreprocessor preprocessing, @NotNull M baseModel, @NotNull Map<String, ? extends Object> info) {
        Intrinsics.checkNotNullParameter(baseModel, (String)"baseModel");
        Intrinsics.checkNotNullParameter(info, (String)"info");
        this.preprocessing = preprocessing;
        this.baseModel = baseModel;
        this.info = info;
        this.inputFeatures$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FeatureSet>(this){
            final /* synthetic */ ModelPipeline<M, P> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final FeatureSet invoke() {
                if (this.this$0.getPreprocessing() == null) {
                    return ((MLModel)this.this$0.getBaseModel()).getInputFeatures();
                }
                return this.this$0.getPreprocessing().deduceRequiredInput(((MLModel)this.this$0.getBaseModel()).getInputFeatures());
            }
        }));
        this.predictedType = ((MLModel)this.baseModel).getPredictedType();
    }

    @Nullable
    public final FeaturePreprocessor getPreprocessing() {
        return this.preprocessing;
    }

    @NotNull
    public final M getBaseModel() {
        return this.baseModel;
    }

    @NotNull
    public final Map<String, Object> getInfo() {
        return this.info;
    }

    @Override
    @NotNull
    public FeatureSet getInputFeatures() {
        Lazy lazy = this.inputFeatures$delegate;
        return (FeatureSet)lazy.getValue();
    }

    @Override
    @NotNull
    public Class<? extends P> getPredictedType() {
        return this.predictedType;
    }

    @Override
    @NotNull
    protected P predictWithInputFeatures(@NotNull Collection<? extends Feature> features) {
        Intrinsics.checkNotNullParameter(features, (String)"features");
        if (this.preprocessing == null) {
            return ((MLModel)this.baseModel).predict(features);
        }
        Collection<Feature> preprocessed = this.preprocessing.preprocessFeatures(features, ((MLModel)this.baseModel).getInputFeatures());
        return ((MLModel)this.baseModel).predict(preprocessed);
    }

    @Override
    @NotNull
    public DataFrame buildPredictionsDataFrame(@NotNull Collection<? extends P> predictions) {
        Intrinsics.checkNotNullParameter(predictions, (String)"predictions");
        return ((MLModel)this.baseModel).buildPredictionsDataFrame(predictions);
    }

    @Override
    @NotNull
    protected List<P> predictBatchWithInputFeatures(@NotNull Collection<? extends Feature> contextFeatures, @NotNull List<? extends Collection<? extends Feature>> itemFeatures) {
        Intrinsics.checkNotNullParameter(contextFeatures, (String)"contextFeatures");
        Intrinsics.checkNotNullParameter(itemFeatures, (String)"itemFeatures");
        Pair<Collection<Feature>, List<Collection<Feature>>> pair = this.preprocessing;
        if (pair == null || (pair = pair.preprocessFeaturesBatch(contextFeatures, itemFeatures, ((MLModel)this.baseModel).getInputFeatures())) == null) {
            pair = TuplesKt.to(contextFeatures, itemFeatures);
        }
        Pair<Collection<Feature>, List<Collection<Feature>>> pair2 = pair;
        Collection preprocessedContextFeatures = (Collection)pair2.component1();
        List preprocessedItemFeatures = (List)pair2.component2();
        return ((MLModel)this.baseModel).predictBatch((Collection<Feature>)preprocessedContextFeatures, preprocessedItemFeatures);
    }

    public final /* synthetic */ <T> ModelPipeline<MLModel<T>, T> predicting() {
        boolean $i$f$predicting = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        if (!Object.class.isAssignableFrom(((MLModel)this.getBaseModel()).getPredictedType())) {
            boolean bl = false;
            String string = ((MLModel)this.getBaseModel()).getPredictedType().getName();
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            String string2 = "ML model predicts " + string + ", which is not a kind of " + Object.class.getName();
            throw new IllegalArgumentException(string2.toString());
        }
        FeaturePreprocessor featurePreprocessor = this.getPreprocessing();
        M m = this.getBaseModel();
        Intrinsics.checkNotNull(m, (String)"null cannot be cast to non-null type com.jetbrains.ml.tools.model.MLModel<T of com.jetbrains.ml.tools.model.pipeline.ModelPipeline.predicting>");
        return new ModelPipeline<MLModel, P>(featurePreprocessor, (MLModel)m, this.getInfo());
    }

    @NotNull
    public final ModelPipeline<MLModel<ClassesProbabilities>, ClassesProbabilities> predictingClasses() {
        ModelPipeline this_$iv = this;
        boolean $i$f$predicting = false;
        if (!ClassesProbabilities.class.isAssignableFrom(((MLModel)this_$iv.getBaseModel()).getPredictedType())) {
            boolean bl = false;
            String string = "ML model predicts " + ((MLModel)this_$iv.getBaseModel()).getPredictedType().getName() + ", which is not a kind of " + ClassesProbabilities.class.getName();
            throw new IllegalArgumentException(string.toString());
        }
        FeaturePreprocessor featurePreprocessor = this_$iv.getPreprocessing();
        M m = this_$iv.getBaseModel();
        Intrinsics.checkNotNull(m, (String)"null cannot be cast to non-null type com.jetbrains.ml.tools.model.MLModel<T of com.jetbrains.ml.tools.model.pipeline.ModelPipeline.predicting>");
        return new ModelPipeline<MLModel<ClassesProbabilities>, ClassesProbabilities>(featurePreprocessor, (MLModel<ClassesProbabilities>)m, this_$iv.getInfo());
    }

    @NotNull
    public final ModelPipeline<MLModel<Logit>, Logit> predictingLogit() {
        ModelPipeline this_$iv = this;
        boolean $i$f$predicting = false;
        if (!Logit.class.isAssignableFrom(((MLModel)this_$iv.getBaseModel()).getPredictedType())) {
            boolean bl = false;
            String string = "ML model predicts " + ((MLModel)this_$iv.getBaseModel()).getPredictedType().getName() + ", which is not a kind of " + Logit.class.getName();
            throw new IllegalArgumentException(string.toString());
        }
        FeaturePreprocessor featurePreprocessor = this_$iv.getPreprocessing();
        M m = this_$iv.getBaseModel();
        Intrinsics.checkNotNull(m, (String)"null cannot be cast to non-null type com.jetbrains.ml.tools.model.MLModel<T of com.jetbrains.ml.tools.model.pipeline.ModelPipeline.predicting>");
        return new ModelPipeline<MLModel<Logit>, Logit>(featurePreprocessor, (MLModel<Logit>)m, this_$iv.getInfo());
    }

    @NotNull
    public final ModelPipeline<MLModel<Probability>, Probability> predictingProbability() {
        ModelPipeline this_$iv = this;
        boolean $i$f$predicting = false;
        if (!Probability.class.isAssignableFrom(((MLModel)this_$iv.getBaseModel()).getPredictedType())) {
            boolean bl = false;
            String string = "ML model predicts " + ((MLModel)this_$iv.getBaseModel()).getPredictedType().getName() + ", which is not a kind of " + Probability.class.getName();
            throw new IllegalArgumentException(string.toString());
        }
        FeaturePreprocessor featurePreprocessor = this_$iv.getPreprocessing();
        M m = this_$iv.getBaseModel();
        Intrinsics.checkNotNull(m, (String)"null cannot be cast to non-null type com.jetbrains.ml.tools.model.MLModel<T of com.jetbrains.ml.tools.model.pipeline.ModelPipeline.predicting>");
        return new ModelPipeline<MLModel<Probability>, Probability>(featurePreprocessor, (MLModel<Probability>)m, this_$iv.getInfo());
    }
}

