/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auth.blocking;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.security.auth.blocking.ClientBlockRegistry;

public class HeapBasedClientBlockRegistry<ClientIdType>
implements ClientBlockRegistry<ClientIdType> {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final Cache<ClientIdType, Long> cache;
    private final Class<ClientIdType> clientIdType;

    public HeapBasedClientBlockRegistry(long expiryMs, int maxEntries, Class<ClientIdType> clientIdType) {
        this.clientIdType = clientIdType;
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(expiryMs, TimeUnit.MILLISECONDS).maximumSize((long)maxEntries).concurrencyLevel(4).removalListener(new RemovalListener<ClientIdType, Long>(){

            public void onRemoval(RemovalNotification<ClientIdType, Long> notification) {
                if (HeapBasedClientBlockRegistry.this.log.isInfoEnabled()) {
                    HeapBasedClientBlockRegistry.this.log.info("Unblocking " + String.valueOf(notification.getKey()));
                }
            }
        }).build();
    }

    @Override
    public boolean isBlocked(ClientIdType clientId) {
        return this.cache.getIfPresent(clientId) != null;
    }

    @Override
    public void block(ClientIdType clientId) {
        if (this.log.isInfoEnabled()) {
            this.log.info("Blocking " + String.valueOf(clientId));
        }
        this.cache.put(clientId, (Object)System.currentTimeMillis());
    }

    @Override
    public Class<ClientIdType> getClientIdType() {
        return this.clientIdType;
    }
}

