/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.commons.os;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.opensearch.performanceanalyzer.commons.collectors.StatsCollector;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatExceptionCode;

public class SchemaFileParser {
    private static final Logger LOGGER = LogManager.getLogger(SchemaFileParser.class);
    private String filename = null;
    private String[] keys = null;
    private FieldTypes[] types = null;
    private boolean preProcess = false;

    public SchemaFileParser(String file, String[] keys, FieldTypes[] types) {
        this.filename = file;
        this.keys = (String[])keys.clone();
        this.types = (FieldTypes[])types.clone();
    }

    public SchemaFileParser(String file, String[] keys, FieldTypes[] types, boolean preProcess) {
        this.filename = file;
        this.keys = (String[])keys.clone();
        this.types = (FieldTypes[])types.clone();
        this.preProcess = preProcess;
    }

    private Object getTypedValue(String value, FieldTypes type) {
        switch (type.ordinal()) {
            case 2: {
                return Character.valueOf(value.charAt(0));
            }
            case 0: {
                return Integer.valueOf(value);
            }
            case 1: {
                return value;
            }
            case 3: {
                return Long.parseUnsignedLong(value);
            }
            case 4: {
                return Double.valueOf(value);
            }
        }
        return null;
    }

    private void generateMap(String content, Map<String, Object> map) {
        String[] splitvalues = content.trim().split(" +");
        String[] values = this.preProcess(splitvalues);
        if (values.length < this.types.length) {
            LOGGER.debug("Content Values tokens {} length is less than types {} length with ExceptionCode: {}", new Supplier[]{() -> Arrays.toString(values), () -> Arrays.toString((Object[])this.types), () -> StatExceptionCode.SCHEMA_PARSER_ERROR.toString()});
            StatsCollector.instance().logException(StatExceptionCode.SCHEMA_PARSER_ERROR);
        }
        int lim = Math.min(values.length, this.types.length);
        for (int idx = 0; idx < lim; ++idx) {
            map.put(this.keys[idx], this.getTypedValue(values[idx], this.types[idx]));
        }
    }

    private String[] preProcess(String[] tokens) {
        if (this.preProcess) {
            ArrayList<String> processedTokens = new ArrayList<String>();
            StringBuffer tmp = new StringBuffer();
            boolean beingProcessed = false;
            for (int idx = 0; idx < tokens.length; ++idx) {
                if (beingProcessed) {
                    tmp.append(tokens[idx]);
                    if (!tokens[idx].endsWith(")")) continue;
                    beingProcessed = false;
                    processedTokens.add(tmp.toString());
                    tmp.setLength(0);
                    continue;
                }
                if (tokens[idx].startsWith("(")) {
                    if (tokens[idx].endsWith(")")) {
                        processedTokens.add(tokens[idx]);
                        continue;
                    }
                    beingProcessed = true;
                    tmp.append(tokens[idx]);
                    continue;
                }
                processedTokens.add(tokens[idx]);
            }
            return processedTokens.toArray(new String[processedTokens.size()]);
        }
        return tokens;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> parse() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try (FileReader fileReader = new FileReader(new File(this.filename));
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            String line = bufferedReader.readLine();
            if (line == null) {
                HashMap<String, Object> hashMap = map;
                return hashMap;
            }
            this.generateMap(line, map);
            return map;
        }
        catch (FileNotFoundException e) {
            LOGGER.debug("FileNotFound in parse with exception: {}", new Supplier[]{() -> e.toString()});
            return map;
        }
        catch (Exception e) {
            LOGGER.debug("Error in parse with exception: {} with ExceptionCode: {}", new Supplier[]{() -> e.toString(), () -> StatExceptionCode.SCHEMA_PARSER_ERROR.toString()});
            StatsCollector.instance().logException(StatExceptionCode.SCHEMA_PARSER_ERROR);
        }
        return map;
    }

    public List<Map<String, Object>> parseMultiple() {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        try (FileReader fileReader = new FileReader(new File(this.filename));
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                this.generateMap(line, map);
                mapList.add(map);
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.debug("FileNotFound in parse with exception: {}", new Supplier[]{() -> e.toString()});
        }
        catch (Exception e) {
            LOGGER.debug("Error in parseMultiple with exception: {} with ExceptionCode: {}", new Supplier[]{() -> e.toString(), () -> StatExceptionCode.SCHEMA_PARSER_ERROR.toString()});
            StatsCollector.instance().logException(StatExceptionCode.SCHEMA_PARSER_ERROR);
        }
        return mapList;
    }

    public static enum FieldTypes {
        INT,
        STRING,
        CHAR,
        ULONG,
        DOUBLE;

    }
}

