/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.query_dsl.Intervals;
import org.opensearch.client.opensearch._types.query_dsl.IntervalsFilter;
import org.opensearch.client.opensearch._types.query_dsl.IntervalsQuery;
import org.opensearch.client.opensearch._types.query_dsl.IntervalsQueryVariant;
import org.opensearch.client.opensearch._types.query_dsl.IntervalsVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class IntervalsMatch
implements IntervalsVariant,
IntervalsQueryVariant,
PlainJsonSerializable,
ToCopyableBuilder<Builder, IntervalsMatch> {
    @Nullable
    private final String analyzer;
    @Nullable
    private final IntervalsFilter filter;
    @Nullable
    private final Integer maxGaps;
    @Nullable
    private final Boolean ordered;
    @Nonnull
    private final String query;
    @Nullable
    private final String useField;
    public static final JsonpDeserializer<IntervalsMatch> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IntervalsMatch::setupIntervalsMatchDeserializer);

    private IntervalsMatch(Builder builder) {
        this.analyzer = builder.analyzer;
        this.filter = builder.filter;
        this.maxGaps = builder.maxGaps;
        this.ordered = builder.ordered;
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
        this.useField = builder.useField;
    }

    public static IntervalsMatch of(Function<Builder, ObjectBuilder<IntervalsMatch>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Intervals.Kind _intervalsKind() {
        return Intervals.Kind.Match;
    }

    @Override
    public IntervalsQuery.Kind _intervalsQueryKind() {
        return IntervalsQuery.Kind.Match;
    }

    @Nullable
    public final String analyzer() {
        return this.analyzer;
    }

    @Nullable
    public final IntervalsFilter filter() {
        return this.filter;
    }

    @Nullable
    public final Integer maxGaps() {
        return this.maxGaps;
    }

    @Nullable
    public final Boolean ordered() {
        return this.ordered;
    }

    @Nonnull
    public final String query() {
        return this.query;
    }

    @Nullable
    public final String useField() {
        return this.useField;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        if (this.filter != null) {
            generator.writeKey("filter");
            this.filter.serialize(generator, mapper);
        }
        if (this.maxGaps != null) {
            generator.writeKey("max_gaps");
            generator.write(this.maxGaps.intValue());
        }
        if (this.ordered != null) {
            generator.writeKey("ordered");
            generator.write(this.ordered.booleanValue());
        }
        generator.writeKey("query");
        generator.write(this.query);
        if (this.useField != null) {
            generator.writeKey("use_field");
            generator.write(this.useField);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupIntervalsMatchDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer");
        op.add(Builder::filter, IntervalsFilter._DESERIALIZER, "filter");
        op.add(Builder::maxGaps, JsonpDeserializer.integerDeserializer(), "max_gaps");
        op.add(Builder::ordered, JsonpDeserializer.booleanDeserializer(), "ordered");
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query");
        op.add(Builder::useField, JsonpDeserializer.stringDeserializer(), "use_field");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.analyzer);
        result = 31 * result + Objects.hashCode(this.filter);
        result = 31 * result + Objects.hashCode(this.maxGaps);
        result = 31 * result + Objects.hashCode(this.ordered);
        result = 31 * result + this.query.hashCode();
        result = 31 * result + Objects.hashCode(this.useField);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntervalsMatch other = (IntervalsMatch)o;
        return Objects.equals(this.analyzer, other.analyzer) && Objects.equals(this.filter, other.filter) && Objects.equals(this.maxGaps, other.maxGaps) && Objects.equals(this.ordered, other.ordered) && this.query.equals(other.query) && Objects.equals(this.useField, other.useField);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, IntervalsMatch> {
        @Nullable
        private String analyzer;
        @Nullable
        private IntervalsFilter filter;
        @Nullable
        private Integer maxGaps;
        @Nullable
        private Boolean ordered;
        private String query;
        @Nullable
        private String useField;

        public Builder() {
        }

        private Builder(IntervalsMatch o) {
            this.analyzer = o.analyzer;
            this.filter = o.filter;
            this.maxGaps = o.maxGaps;
            this.ordered = o.ordered;
            this.query = o.query;
            this.useField = o.useField;
        }

        private Builder(Builder o) {
            this.analyzer = o.analyzer;
            this.filter = o.filter;
            this.maxGaps = o.maxGaps;
            this.ordered = o.ordered;
            this.query = o.query;
            this.useField = o.useField;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        @Nonnull
        public final Builder filter(@Nullable IntervalsFilter value) {
            this.filter = value;
            return this;
        }

        @Nonnull
        public final Builder filter(Function<IntervalsFilter.Builder, ObjectBuilder<IntervalsFilter>> fn) {
            return this.filter(fn.apply(new IntervalsFilter.Builder()).build());
        }

        @Nonnull
        public final Builder maxGaps(@Nullable Integer value) {
            this.maxGaps = value;
            return this;
        }

        @Nonnull
        public final Builder ordered(@Nullable Boolean value) {
            this.ordered = value;
            return this;
        }

        @Nonnull
        public final Builder query(String value) {
            this.query = value;
            return this;
        }

        @Nonnull
        public final Builder useField(@Nullable String value) {
            this.useField = value;
            return this;
        }

        @Override
        @Nonnull
        public IntervalsMatch build() {
            this._checkSingleUse();
            return new IntervalsMatch(this);
        }
    }
}

