/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.util;

public final class ByteUtils {
    private ByteUtils() {
    }

    public static long zigZagDecode(long n) {
        return n >>> 1 ^ -(n & 1L);
    }

    public static long zigZagEncode(long n) {
        return n >> 63 ^ n << 1;
    }

    public static void writeLongLE(long l, byte[] arr, int offset) {
        for (int i = 0; i < 8; ++i) {
            arr[offset++] = (byte)l;
            l >>>= 8;
        }
        assert (l == 0L);
    }

    public static byte[] toByteArrayBE(long l) {
        byte[] result = new byte[8];
        for (int i = 7; i >= 0; --i) {
            result[i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        return result;
    }

    public static long readLongLE(byte[] arr, int offset) {
        long l = (long)arr[offset++] & 0xFFL;
        for (int i = 1; i < 8; ++i) {
            l |= ((long)arr[offset++] & 0xFFL) << 8 * i;
        }
        return l;
    }

    public static void writeIntLE(int l, byte[] arr, int offset) {
        for (int i = 0; i < 4; ++i) {
            arr[offset++] = (byte)l;
            l >>>= 8;
        }
        assert (l == 0);
    }

    public static int readIntLE(byte[] arr, int offset) {
        int l = arr[offset++] & 0xFF;
        for (int i = 1; i < 4; ++i) {
            l |= (arr[offset++] & 0xFF) << 8 * i;
        }
        return l;
    }

    public static void writeDoubleLE(double d, byte[] arr, int offset) {
        ByteUtils.writeLongLE(Double.doubleToRawLongBits(d), arr, offset);
    }

    public static double readDoubleLE(byte[] arr, int offset) {
        return Double.longBitsToDouble(ByteUtils.readLongLE(arr, offset));
    }

    public static void writeFloatLE(float d, byte[] arr, int offset) {
        ByteUtils.writeIntLE(Float.floatToRawIntBits(d), arr, offset);
    }

    public static float readFloatLE(byte[] arr, int offset) {
        return Float.intBitsToFloat(ByteUtils.readIntLE(arr, offset));
    }
}

