/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util;

import org.hibernate.internal.util.CharSequenceHelper;

public final class SubSequence
implements CharSequence {
    private final CharSequence sequence;
    private final int start;
    private final int length;

    public SubSequence(CharSequence sequence, int start, int end) {
        this.sequence = sequence;
        this.start = start;
        this.length = end - start;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.sequence.charAt(index + this.start);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start < 0 || start >= this.length) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.length) {
            throw new StringIndexOutOfBoundsException(end);
        }
        return this.sequence.subSequence(this.start + start, this.start + end);
    }

    public int lastIndexOf(char c, int fromIndex, int endIndex) {
        int idx = CharSequenceHelper.lastIndexOf(this.sequence, c, this.start + fromIndex, this.start + endIndex);
        if (idx == -1) {
            return -1;
        }
        return idx - this.start;
    }

    public int indexOf(char c, int fromIndex, int endIndex) {
        int idx = CharSequenceHelper.indexOf(this.sequence, c, this.start + fromIndex, this.start + endIndex);
        if (idx == -1) {
            return -1;
        }
        return idx - this.start;
    }

    public int indexOf(String s, int fromIndex, int endIndex) {
        int idx = CharSequenceHelper.indexOf(this.sequence, s, this.start + fromIndex, this.start + endIndex);
        if (idx == -1) {
            return -1;
        }
        return idx - this.start;
    }

    @Override
    public String toString() {
        return this.sequence.subSequence(this.start, this.start + this.length).toString();
    }
}

