/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.ClientStatistics;
import org.infinispan.client.hotrod.impl.ClientTopology;
import org.infinispan.client.hotrod.impl.operations.AbstractKeyOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.telemetry.impl.TelemetryService;
import org.infinispan.commons.util.Util;

@Immutable
public abstract class AbstractKeyValueOperation<T>
extends AbstractKeyOperation<T> {
    protected final byte[] value;
    protected final long lifespan;
    protected final long maxIdle;
    protected final TimeUnit lifespanTimeUnit;
    protected final TimeUnit maxIdleTimeUnit;

    protected AbstractKeyValueOperation(short requestCode, short responseCode, Codec codec, ChannelFactory channelFactory, Object key, byte[] keyBytes, byte[] cacheName, AtomicReference<ClientTopology> clientTopology, int flags, Configuration cfg, byte[] value, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit, DataFormat dataFormat, ClientStatistics clientStatistics, TelemetryService telemetryService) {
        super(requestCode, responseCode, codec, channelFactory, key, keyBytes, cacheName, clientTopology, flags, cfg, dataFormat, clientStatistics, telemetryService);
        this.value = value;
        this.lifespan = lifespan;
        this.maxIdle = maxIdle;
        this.lifespanTimeUnit = lifespanTimeUnit;
        this.maxIdleTimeUnit = maxIdleTimeUnit;
    }

    protected void sendKeyValueOperation(Channel channel) {
        ByteBuf buf = channel.alloc().buffer(this.codec.estimateHeaderSize(this.header) + this.keyBytes.length + this.codec.estimateExpirationSize(this.lifespan, this.lifespanTimeUnit, this.maxIdle, this.maxIdleTimeUnit) + this.value.length);
        this.codec.writeHeader(buf, this.header);
        ByteBufUtil.writeArray(buf, this.keyBytes);
        this.codec.writeExpirationParams(buf, this.lifespan, this.lifespanTimeUnit, this.maxIdle, this.maxIdleTimeUnit);
        ByteBufUtil.writeArray(buf, this.value);
        channel.writeAndFlush((Object)buf);
    }

    @Override
    protected void addParams(StringBuilder sb) {
        super.addParams(sb);
        sb.append(", value=").append(Util.printArray((byte[])this.value));
    }
}

