/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.protostream.builder;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.api.protostream.builder.FieldBuilder;
import org.infinispan.api.protostream.builder.ProtoBuf;

public class MessageBuilder {
    final ProtoBuf parent;
    private final String name;
    private final List<FieldBuilder> fields = new ArrayList<FieldBuilder>();
    private boolean indexed = false;

    public MessageBuilder(ProtoBuf parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public MessageBuilder indexed() {
        this.indexed = true;
        return this;
    }

    public FieldBuilder required(String name, int number, String type) {
        FieldBuilder field = new FieldBuilder(this, name, number, true, type);
        this.fields.add(field);
        return field;
    }

    public FieldBuilder optional(String name, int number, String type) {
        FieldBuilder field = new FieldBuilder(this, name, number, false, type);
        this.fields.add(field);
        return field;
    }

    public String build() {
        return this.parent.build();
    }

    void write(StringBuilder builder) {
        if (this.indexed) {
            builder.append("/**\n");
            builder.append(" * @Indexed\n");
            builder.append(" */\n");
        }
        builder.append("message ");
        builder.append(this.name);
        builder.append(" {");
        ProtoBuf.blankLine(builder);
        for (FieldBuilder field : this.fields) {
            field.write(builder);
        }
        builder.append("}");
        ProtoBuf.blankLine(builder);
    }
}

