/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.CharSequenceHelper;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.spi.PrimitiveJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class BooleanJavaType
extends AbstractClassJavaType<Boolean>
implements PrimitiveJavaType<Boolean> {
    public static final BooleanJavaType INSTANCE = new BooleanJavaType();
    private final char characterValueTrue;
    private final char characterValueFalse;
    private final char characterValueTrueLC;
    private final String stringValueTrue;
    private final String stringValueFalse;

    public BooleanJavaType() {
        this('Y', 'N');
    }

    public BooleanJavaType(char characterValueTrue, char characterValueFalse) {
        super(Boolean.class);
        this.characterValueTrue = Character.toUpperCase(characterValueTrue);
        this.characterValueFalse = Character.toUpperCase(characterValueFalse);
        this.characterValueTrueLC = Character.toLowerCase(characterValueTrue);
        this.stringValueTrue = String.valueOf(characterValueTrue);
        this.stringValueFalse = String.valueOf(characterValueFalse);
    }

    @Override
    public boolean useObjectEqualsHashCode() {
        return true;
    }

    @Override
    public String toString(Boolean value) {
        return value == null ? null : value.toString();
    }

    @Override
    public Boolean fromString(CharSequence string) {
        return Boolean.valueOf(string.toString());
    }

    @Override
    public boolean isInstance(Object value) {
        return value instanceof Boolean;
    }

    @Override
    public Boolean fromEncodedString(CharSequence charSequence, int start, int end) {
        switch (charSequence.charAt(start)) {
            case 'T': 
            case 't': {
                return CharSequenceHelper.regionMatchesIgnoreCase(charSequence, start + 1, "rue", 0, 3);
            }
            case 'Y': 
            case 'y': {
                return end == start + 1;
            }
        }
        return false;
    }

    @Override
    public <X> X unwrap(Boolean value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (Boolean.class.isAssignableFrom(type) || type == Object.class) {
            return (X)value;
        }
        if (Byte.class.isAssignableFrom(type)) {
            return (X)this.toByte(value);
        }
        if (Short.class.isAssignableFrom(type)) {
            return (X)this.toShort(value);
        }
        if (Integer.class.isAssignableFrom(type)) {
            return (X)this.toInteger(value);
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)this.toLong(value);
        }
        if (Character.class.isAssignableFrom(type)) {
            return (X)Character.valueOf(value != false ? this.characterValueTrue : this.characterValueFalse);
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)(value != false ? this.stringValueTrue : this.stringValueFalse);
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Boolean wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            Boolean booleanValue = (Boolean)value;
            return booleanValue;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.intValue() != 0;
        }
        if (value instanceof Character) {
            Character character = (Character)value;
            return this.isTrue(character.charValue());
        }
        if (value instanceof String) {
            String string = (String)value;
            return this.isTrue(string);
        }
        throw this.unknownWrap(value.getClass());
    }

    private boolean isTrue(String strValue) {
        return strValue != null && !strValue.isEmpty() && this.isTrue(strValue.charAt(0));
    }

    private boolean isTrue(char charValue) {
        return charValue == this.characterValueTrue || charValue == this.characterValueTrueLC;
    }

    public int toInt(Boolean value) {
        return value != false ? 1 : 0;
    }

    public Byte toByte(Boolean value) {
        return (byte)this.toInt(value);
    }

    public Short toShort(Boolean value) {
        return (short)this.toInt(value);
    }

    public Integer toInteger(Boolean value) {
        return this.toInt(value);
    }

    public Long toLong(Boolean value) {
        return this.toInt(value);
    }

    @Override
    public Class<?> getPrimitiveClass() {
        return Boolean.TYPE;
    }

    @Override
    public Class<Boolean[]> getArrayClass() {
        return Boolean[].class;
    }

    @Override
    public Class<?> getPrimitiveArrayClass() {
        return boolean[].class;
    }

    @Override
    public Boolean getDefaultValue() {
        return false;
    }

    @Override
    public long getDefaultSqlLength(Dialect dialect, JdbcType jdbcType) {
        return 1L;
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect, JdbcType jdbcType) {
        return 1;
    }

    @Override
    public int getDefaultSqlScale(Dialect dialect, JdbcType jdbcType) {
        return 0;
    }

    @Override
    public String getCheckCondition(String columnName, JdbcType jdbcType, BasicValueConverter<Boolean, ?> converter, Dialect dialect) {
        if (converter != null) {
            if (jdbcType.isString()) {
                Object falseValue = converter.toRelationalValue(false);
                Object trueValue = converter.toRelationalValue(true);
                String[] values = BooleanJavaType.getPossibleStringValues(converter, falseValue, trueValue);
                return dialect.getCheckCondition(columnName, values);
            }
            if (jdbcType.isInteger()) {
                BasicValueConverter<Boolean, ?> numericConverter = converter;
                Number falseValue = (Number)numericConverter.toRelationalValue(false);
                Number trueValue = (Number)numericConverter.toRelationalValue(true);
                Long[] values = BooleanJavaType.getPossibleNumericValues(numericConverter, falseValue, trueValue);
                return dialect.getCheckCondition(columnName, values);
            }
        }
        return null;
    }

    private static Long[] getPossibleNumericValues(BasicValueConverter<Boolean, ? extends Number> numericConverter, Number falseValue, Number trueValue) {
        Number nullValue = null;
        try {
            nullValue = numericConverter.toRelationalValue(null);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Long[] values = new Long[nullValue != null ? 3 : 2];
        values[0] = falseValue != null ? Long.valueOf(falseValue.longValue()) : null;
        Long l = values[1] = trueValue != null ? Long.valueOf(trueValue.longValue()) : null;
        if (nullValue != null) {
            values[2] = nullValue.longValue();
        }
        return values;
    }

    private static String[] getPossibleStringValues(BasicValueConverter<Boolean, ?> stringConverter, Object falseValue, Object trueValue) {
        Object nullValue = null;
        try {
            nullValue = stringConverter.toRelationalValue(null);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        String[] values = new String[nullValue != null ? 3 : 2];
        values[0] = falseValue != null ? falseValue.toString() : null;
        String string = values[1] = trueValue != null ? trueValue.toString() : null;
        if (nullValue != null) {
            values[2] = nullValue.toString();
        }
        return values;
    }
}

