/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.model.ast;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.jdbc.Expectation;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.ast.AbstractRestrictedTableMutation;
import org.hibernate.sql.model.ast.ColumnValueBinding;
import org.hibernate.sql.model.ast.ColumnValueParameter;
import org.hibernate.sql.model.ast.ColumnWriteFragment;
import org.hibernate.sql.model.ast.MutatingTableReference;
import org.hibernate.sql.model.ast.TableUpdate;
import org.hibernate.sql.model.jdbc.JdbcUpdateMutation;

public abstract class AbstractTableUpdate<O extends MutationOperation>
extends AbstractRestrictedTableMutation<O>
implements TableUpdate<O> {
    private final List<ColumnValueBinding> valueBindings;

    public AbstractTableUpdate(MutatingTableReference mutatingTable, MutationTarget<?> mutationTarget, String sqlComment, List<ColumnValueBinding> valueBindings, List<ColumnValueBinding> keyRestrictionBindings, List<ColumnValueBinding> optLockRestrictionBindings) {
        super(mutatingTable, mutationTarget, sqlComment, keyRestrictionBindings, optLockRestrictionBindings, AbstractTableUpdate.collectParameters(valueBindings, keyRestrictionBindings, optLockRestrictionBindings));
        this.valueBindings = valueBindings;
    }

    public <T> AbstractTableUpdate(MutatingTableReference tableReference, MutationTarget<?> mutationTarget, String sqlComment, List<ColumnValueBinding> valueBindings, List<ColumnValueBinding> keyRestrictionBindings, List<ColumnValueBinding> optLockRestrictionBindings, List<ColumnValueParameter> parameters) {
        super(tableReference, mutationTarget, sqlComment, keyRestrictionBindings, optLockRestrictionBindings, parameters);
        this.valueBindings = valueBindings;
    }

    public static List<ColumnValueParameter> collectParameters(List<ColumnValueBinding> valueBindings, List<ColumnValueBinding> keyRestrictionBindings, List<ColumnValueBinding> optLockRestrictionBindings) {
        ArrayList<ColumnValueParameter> params = new ArrayList<ColumnValueParameter>();
        BiConsumer<Integer, ColumnValueBinding> intermediateConsumer = (index, binding) -> {
            ColumnWriteFragment valueExpression = binding.getValueExpression();
            if (valueExpression != null) {
                params.addAll(valueExpression.getParameters());
            }
        };
        AbstractTableUpdate.forEachThing(valueBindings, intermediateConsumer);
        AbstractTableUpdate.forEachThing(keyRestrictionBindings, intermediateConsumer);
        AbstractTableUpdate.forEachThing(optLockRestrictionBindings, intermediateConsumer);
        return params;
    }

    @Override
    protected String getLoggableName() {
        return "TableUpdate";
    }

    @Override
    public Expectation getExpectation() {
        return this.getMutatingTable().getTableMapping().getUpdateDetails().getExpectation();
    }

    @Override
    public List<ColumnValueBinding> getValueBindings() {
        return this.valueBindings;
    }

    @Override
    public void forEachValueBinding(BiConsumer<Integer, ColumnValueBinding> consumer) {
        AbstractTableUpdate.forEachThing(this.valueBindings, consumer);
    }

    @Override
    public void forEachParameter(Consumer<ColumnValueParameter> consumer) {
        BiConsumer<Integer, ColumnValueBinding> intermediateConsumer = (index, binding) -> {
            for (ColumnValueParameter parameter : binding.getValueExpression().getParameters()) {
                consumer.accept(parameter);
            }
        };
        AbstractTableUpdate.forEachThing(this.getValueBindings(), intermediateConsumer);
        AbstractTableUpdate.forEachThing(this.getKeyBindings(), intermediateConsumer);
        AbstractTableUpdate.forEachThing(this.getOptimisticLockBindings(), intermediateConsumer);
    }

    @Override
    protected O createMutationOperation(TableMapping tableDetails, String sql, List<JdbcParameterBinder> effectiveBinders) {
        return (O)new JdbcUpdateMutation(tableDetails, this.getMutationTarget(), sql, this.isCallable(), this.getExpectation(), effectiveBinders);
    }
}

