/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.server.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.grpc.common.CodecException;
import io.vertx.grpc.common.GrpcError;
import io.vertx.grpc.common.GrpcMessage;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.common.GrpcStatus;
import io.vertx.grpc.common.impl.GrpcMessageImpl;
import io.vertx.grpc.common.impl.Utils;
import io.vertx.grpc.server.GrpcServerResponse;
import io.vertx.grpc.server.impl.GrpcServerRequestImpl;
import java.util.Map;
import java.util.Objects;

public class GrpcServerResponseImpl<Req, Resp>
implements GrpcServerResponse<Req, Resp> {
    private final GrpcServerRequestImpl<Req, Resp> request;
    private final HttpServerResponse httpResponse;
    private final GrpcMessageEncoder<Resp> encoder;
    private String encoding;
    private GrpcStatus status = GrpcStatus.OK;
    private String statusMessage;
    private boolean headersSent;
    private boolean trailersSent;
    private boolean cancelled;
    private MultiMap headers;
    private MultiMap trailers;

    public GrpcServerResponseImpl(GrpcServerRequestImpl<Req, Resp> request, HttpServerResponse httpResponse, GrpcMessageEncoder<Resp> encoder) {
        this.request = request;
        this.httpResponse = httpResponse;
        this.encoder = encoder;
    }

    @Override
    public GrpcServerResponse<Req, Resp> status(GrpcStatus status) {
        Objects.requireNonNull(status);
        this.status = status;
        return this;
    }

    @Override
    public GrpcServerResponse<Req, Resp> statusMessage(String msg) {
        this.statusMessage = msg;
        return this;
    }

    @Override
    public GrpcServerResponse<Req, Resp> encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public MultiMap headers() {
        if (this.headersSent) {
            throw new IllegalStateException("Headers already sent");
        }
        if (this.headers == null) {
            this.headers = MultiMap.caseInsensitiveMultiMap();
        }
        return this.headers;
    }

    @Override
    public MultiMap trailers() {
        if (this.trailersSent) {
            throw new IllegalStateException("Trailers already sent");
        }
        if (this.trailers == null) {
            this.trailers = MultiMap.caseInsensitiveMultiMap();
        }
        return this.trailers;
    }

    @Override
    public GrpcServerResponseImpl<Req, Resp> exceptionHandler(Handler<Throwable> handler) {
        this.httpResponse.exceptionHandler(handler);
        return this;
    }

    public Future<Void> write(Resp message) {
        return this.writeMessage(this.encoder.encode(message));
    }

    public Future<Void> end(Resp message) {
        return this.endMessage(this.encoder.encode(message));
    }

    public Future<Void> writeMessage(GrpcMessage data) {
        return this.writeMessage(data, false);
    }

    public Future<Void> endMessage(GrpcMessage message) {
        return this.writeMessage(message, true);
    }

    public Future<Void> end() {
        return this.writeMessage(null, true);
    }

    @Override
    public Future<Void> writeHead() {
        if (this.cancelled) {
            throw new IllegalStateException("The stream has been cancelled");
        }
        if (this.headersSent) {
            throw new IllegalStateException("The stream headers have already been sent");
        }
        this.headersSent = true;
        MultiMap responseHeaders = this.httpResponse.headers();
        this.setResponseHeaders(responseHeaders);
        return this.httpResponse.writeHead();
    }

    @Override
    public GrpcServerResponse<Req, Resp> setWriteQueueMaxSize(int maxSize) {
        this.httpResponse.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public boolean writeQueueFull() {
        return this.httpResponse.writeQueueFull();
    }

    @Override
    public GrpcServerResponse<Req, Resp> drainHandler(Handler<Void> handler) {
        this.httpResponse.drainHandler(handler);
        return this;
    }

    public void cancel() {
        if (this.cancelled) {
            return;
        }
        this.cancelled = true;
        Future fut = this.request.end();
        if (fut.failed()) {
            return;
        }
        boolean requestEnded = fut.succeeded();
        if (!requestEnded || !this.trailersSent) {
            this.httpResponse.reset(GrpcError.CANCELLED.http2ResetCode);
        }
    }

    private void setResponseHeaders(MultiMap responseHeaders) {
        if (this.headers != null && this.headers.size() > 0) {
            for (Map.Entry header : this.headers) {
                responseHeaders.add((String)header.getKey(), (String)header.getValue());
            }
        }
        responseHeaders.set("content-type", "application/grpc");
        responseHeaders.set("grpc-encoding", this.encoding);
        responseHeaders.set("grpc-accept-encoding", "gzip");
    }

    private Future<Void> writeMessage(GrpcMessage message, boolean end) {
        if (this.cancelled) {
            throw new IllegalStateException("The stream has been cancelled");
        }
        if (this.trailersSent) {
            throw new IllegalStateException("The stream has been closed");
        }
        if (message == null && !end) {
            throw new IllegalStateException();
        }
        if (this.encoding != null && message != null && !this.encoding.equals(message.encoding())) {
            switch (this.encoding) {
                case "gzip": {
                    message = GrpcMessageEncoder.GZIP.encode((Object)message.payload());
                    break;
                }
                case "identity": {
                    Buffer decoded;
                    if (message.encoding().equals("identity")) break;
                    if (!message.encoding().equals("gzip")) {
                        return Future.failedFuture((String)("Encoding " + message.encoding() + " is not supported"));
                    }
                    try {
                        decoded = (Buffer)GrpcMessageDecoder.GZIP.decode(message);
                    }
                    catch (CodecException e) {
                        return Future.failedFuture((Throwable)e);
                    }
                    message = GrpcMessage.message((String)"identity", (Buffer)decoded);
                }
            }
        }
        boolean trailersOnly = this.status != GrpcStatus.OK && !this.headersSent && end;
        MultiMap responseHeaders = this.httpResponse.headers();
        if (!this.headersSent) {
            this.headersSent = true;
            this.setResponseHeaders(responseHeaders);
        }
        if (end) {
            if (!this.trailersSent) {
                this.trailersSent = true;
            }
            MultiMap responseTrailers = trailersOnly ? this.httpResponse.headers() : this.httpResponse.trailers();
            if (this.trailers != null && this.trailers.size() > 0) {
                for (Map.Entry trailer : this.trailers) {
                    responseTrailers.add((String)trailer.getKey(), (String)trailer.getValue());
                }
            }
            if (!responseHeaders.contains("grpc-status")) {
                responseTrailers.set("grpc-status", this.status.toString());
            }
            if (this.status != GrpcStatus.OK) {
                String msg = this.statusMessage;
                if (msg != null && !responseHeaders.contains("grpc-status-message")) {
                    responseTrailers.set("grpc-message", Utils.utf8PercentEncode((String)msg));
                }
            } else {
                responseTrailers.remove("grpc-message");
            }
            if (message != null) {
                return this.httpResponse.end(GrpcMessageImpl.encode((GrpcMessage)message));
            }
            return this.httpResponse.end();
        }
        return this.httpResponse.write((Object)GrpcMessageImpl.encode((GrpcMessage)message));
    }

    public void write(Resp data, Handler<AsyncResult<Void>> handler) {
        this.write(data).onComplete(handler);
    }

    public void end(Handler<AsyncResult<Void>> handler) {
        this.end().onComplete(handler);
    }
}

