/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.UniRetry;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.uni.UniOnFailureFlatMap;
import io.smallrye.mutiny.operators.uni.UniOnFailureTransform;
import io.smallrye.mutiny.operators.uni.UniOnItemConsume;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class UniOnFailure<T> {
    private final Uni<T> upstream;
    private final Predicate<? super Throwable> predicate;

    public UniOnFailure(Uni<T> upstream, Predicate<? super Throwable> predicate) {
        this.upstream = upstream;
        this.predicate = predicate == null ? x -> true : predicate;
    }

    @CheckReturnValue
    public Uni<T> invoke(Consumer<Throwable> callback) {
        Consumer<Throwable> actual = Infrastructure.decorate(ParameterValidation.nonNull(callback, "callback"));
        return Infrastructure.onUniCreation(new UniOnItemConsume<T>(this.upstream, null, actual, this.predicate));
    }

    @CheckReturnValue
    public Uni<T> invoke(Runnable callback) {
        Runnable actual = ParameterValidation.nonNull(callback, "callback");
        return this.invoke((Throwable ignored) -> actual.run());
    }

    @CheckReturnValue
    public Uni<T> call(Function<Throwable, Uni<?>> action) {
        Function<Throwable, Uni<?>> actual = Infrastructure.decorate(ParameterValidation.nonNull(action, "action"));
        return this.recoverWithUni((? super Throwable failure) -> {
            Uni uni = Objects.requireNonNull((Uni)actual.apply((Throwable)failure), "The `action` produced a `null` uni");
            return uni.onItem().failWith(ignored -> failure).onFailure().transform(subFailure -> {
                if (subFailure != failure) {
                    return new CompositeException((Throwable)failure, (Throwable)subFailure);
                }
                return subFailure;
            });
        });
    }

    @CheckReturnValue
    public Uni<T> call(Supplier<Uni<?>> supplier) {
        Supplier<Uni<?>> actual = Infrastructure.decorate(ParameterValidation.nonNull(supplier, "supplier"));
        return this.call((Throwable ignored) -> (Uni)actual.get());
    }

    @CheckReturnValue
    public Uni<T> transform(Function<? super Throwable, ? extends Throwable> mapper) {
        Function<? super Throwable, ? extends Throwable> actual = Infrastructure.decorate(ParameterValidation.nonNull(mapper, "mapper"));
        return Infrastructure.onUniCreation(new UniOnFailureTransform(this.upstream, this.predicate, actual));
    }

    @CheckReturnValue
    public Uni<T> recoverWithItem(T fallback) {
        return this.recoverWithItem(() -> fallback);
    }

    @CheckReturnValue
    public Uni<T> recoverWithItem(Supplier<T> supplier) {
        Supplier actual = Infrastructure.decorate(ParameterValidation.nonNull(supplier, "supplier"));
        return this.recoverWithItem((? super Throwable ignored) -> actual.get());
    }

    @CheckReturnValue
    public Uni<T> recoverWithItem(Function<? super Throwable, ? extends T> function) {
        Function actual = Infrastructure.decorate(ParameterValidation.nonNull(function, "function"));
        return Infrastructure.onUniCreation(new UniOnFailureFlatMap(this.upstream, this.predicate, failure -> {
            Object newResult = actual.apply((Throwable)failure);
            return Uni.createFrom().item(newResult);
        }));
    }

    @CheckReturnValue
    public Uni<T> recoverWithUni(Function<? super Throwable, Uni<? extends T>> function) {
        Function actual = Infrastructure.decorate(ParameterValidation.nonNull(function, "function"));
        return Infrastructure.onUniCreation(new UniOnFailureFlatMap(this.upstream, this.predicate, actual));
    }

    @CheckReturnValue
    public Uni<T> recoverWithUni(Supplier<Uni<? extends T>> supplier) {
        Supplier actual = Infrastructure.decorate(ParameterValidation.nonNull(supplier, "supplier"));
        return this.recoverWithUni((? super Throwable ignored) -> (Uni)actual.get());
    }

    @CheckReturnValue
    public Uni<T> recoverWithUni(Uni<? extends T> fallback) {
        return this.recoverWithUni(() -> fallback);
    }

    @CheckReturnValue
    public UniRetry<T> retry() {
        return new UniRetry<T>(this.upstream, this.predicate);
    }

    @CheckReturnValue
    public Uni<T> recoverWithNull() {
        return this.recoverWithItem((? super Throwable failure) -> null);
    }
}

