/*
 * Decompiled with CFR 0.152.
 */
package naga.packetwriter;

import java.nio.ByteBuffer;
import javax.crypto.Cipher;
import naga.PacketWriter;

public class CipherPacketWriter
implements PacketWriter {
    private final Cipher m_cipher;
    private PacketWriter m_packetWriter;

    public CipherPacketWriter(Cipher cipher, PacketWriter packetWriter) {
        this.m_cipher = cipher;
        this.m_packetWriter = packetWriter;
    }

    public PacketWriter getPacketWriter() {
        return this.m_packetWriter;
    }

    public void setPacketWriter(PacketWriter packetWriter) {
        this.m_packetWriter = packetWriter;
    }

    @Override
    public ByteBuffer[] write(ByteBuffer[] byteBufferArray) {
        byteBufferArray = this.m_packetWriter.write(byteBufferArray);
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[byteBufferArray.length];
        try {
            for (int i = 0; i < byteBufferArray.length; ++i) {
                byteBufferArray2[i] = ByteBuffer.allocate(this.m_cipher.getOutputSize(byteBufferArray[i].remaining()));
                if (i == byteBufferArray.length - 1) {
                    this.m_cipher.doFinal(byteBufferArray[i], byteBufferArray2[i]);
                } else {
                    this.m_cipher.update(byteBufferArray[i], byteBufferArray2[i]);
                }
                assert (byteBufferArray[i].remaining() == 0);
                byteBufferArray2[i].flip();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return byteBufferArray2;
    }
}

