/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.cache.ArtifactResolutionControl;
import org.gradle.api.internal.artifacts.cache.DependencyResolutionControl;
import org.gradle.api.internal.artifacts.cache.ModuleResolutionControl;
import org.gradle.api.internal.artifacts.cache.ResolutionControl;
import org.gradle.api.internal.artifacts.ivyservice.CacheExpirationControl;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions.DefaultResolvedModuleVersion;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;

public class DefaultCacheExpirationControl
implements CacheExpirationControl {
    private final ImmutableList<Action<? super DependencyResolutionControl>> dependencyCacheRules;
    private final ImmutableList<Action<? super ModuleResolutionControl>> moduleCacheRules;
    private final ImmutableList<Action<? super ArtifactResolutionControl>> artifactCacheRules;
    private final long keepDynamicVersionsFor;
    private final long keepChangingModulesFor;
    private final boolean offline;
    private final boolean refresh;

    public DefaultCacheExpirationControl(ImmutableList<Action<? super DependencyResolutionControl>> dependencyCacheRules, ImmutableList<Action<? super ModuleResolutionControl>> moduleCacheRules, ImmutableList<Action<? super ArtifactResolutionControl>> artifactCacheRules, long keepDynamicVersionsFor, long keepChangingModulesFor, boolean offline, boolean refresh) {
        this.dependencyCacheRules = dependencyCacheRules;
        this.moduleCacheRules = moduleCacheRules;
        this.artifactCacheRules = artifactCacheRules;
        this.keepDynamicVersionsFor = keepDynamicVersionsFor;
        this.keepChangingModulesFor = keepChangingModulesFor;
        this.offline = offline;
        this.refresh = refresh;
    }

    @Override
    public CacheExpirationControl.Expiry versionListExpiry(ModuleIdentifier moduleIdentifier, Set<ModuleVersionIdentifier> moduleVersions, Duration age) {
        CachedDependencyResolutionControl dependencyResolutionControl = new CachedDependencyResolutionControl(moduleIdentifier, moduleVersions, age.toMillis(), this.keepDynamicVersionsFor);
        if (this.applyOfflineRule(dependencyResolutionControl) || this.applyRefreshRule(dependencyResolutionControl)) {
            return dependencyResolutionControl;
        }
        for (Action rule : this.dependencyCacheRules) {
            rule.execute((Object)dependencyResolutionControl);
            if (!dependencyResolutionControl.ruleMatch()) continue;
            break;
        }
        return dependencyResolutionControl;
    }

    @Override
    public CacheExpirationControl.Expiry missingModuleExpiry(ModuleComponentIdentifier component, Duration age) {
        return this.mustRefreshModule(component, null, age, false);
    }

    @Override
    public CacheExpirationControl.Expiry moduleExpiry(ModuleComponentIdentifier component, ResolvedModuleVersion resolvedModuleVersion, Duration age) {
        return this.mustRefreshModule(component, resolvedModuleVersion, age, false);
    }

    @Override
    public CacheExpirationControl.Expiry moduleExpiry(ResolvedModuleVersion resolvedModuleVersion, Duration age, boolean changing) {
        return this.mustRefreshModule(resolvedModuleVersion.getId(), resolvedModuleVersion, age, changing);
    }

    @Override
    public CacheExpirationControl.Expiry moduleArtifactsExpiry(ModuleVersionIdentifier moduleVersionId, Set<ModuleComponentArtifactMetadata> artifacts, Duration age, boolean belongsToChangingModule, boolean moduleDescriptorInSync) {
        CachedModuleResolutionControl resolutionControl = this.mustRefreshModule(moduleVersionId, (ResolvedModuleVersion)new DefaultResolvedModuleVersion(moduleVersionId), age, belongsToChangingModule);
        if (belongsToChangingModule && !moduleDescriptorInSync) {
            resolutionControl.refresh();
        }
        return resolutionControl;
    }

    @Override
    public CacheExpirationControl.Expiry artifactExpiry(ModuleComponentArtifactMetadata artifactMetadata, File cachedArtifactFile, Duration age, boolean belongsToChangingModule, boolean moduleDescriptorInSync) {
        CachedArtifactResolutionControl artifactResolutionControl = new CachedArtifactResolutionControl(artifactMetadata, cachedArtifactFile, age.toMillis(), this.keepChangingModulesFor, belongsToChangingModule);
        if (this.applyOfflineRule(artifactResolutionControl) || this.applyRefreshRule(artifactResolutionControl)) {
            return artifactResolutionControl;
        }
        for (Action rule : this.artifactCacheRules) {
            rule.execute((Object)artifactResolutionControl);
            if (!artifactResolutionControl.ruleMatch()) continue;
            break;
        }
        if (belongsToChangingModule && !moduleDescriptorInSync) {
            artifactResolutionControl.refresh();
        }
        return artifactResolutionControl;
    }

    @Override
    public CacheExpirationControl.Expiry changingModuleExpiry(ModuleComponentIdentifier component, ResolvedModuleVersion resolvedModuleVersion, Duration age) {
        return this.mustRefreshModule(component, resolvedModuleVersion, age, true);
    }

    private CacheExpirationControl.Expiry mustRefreshModule(ModuleComponentIdentifier component, ResolvedModuleVersion version, Duration age, boolean changingModule) {
        return this.mustRefreshModule(DefaultModuleVersionIdentifier.newId(component.getModuleIdentifier(), component.getVersion()), version, age, changingModule);
    }

    private CachedModuleResolutionControl mustRefreshModule(ModuleVersionIdentifier moduleVersionId, ResolvedModuleVersion version, Duration age, boolean changingModule) {
        CachedModuleResolutionControl moduleResolutionControl = new CachedModuleResolutionControl(moduleVersionId, version, changingModule, age.toMillis(), changingModule ? this.keepChangingModulesFor : Long.MAX_VALUE);
        if (this.applyOfflineRule(moduleResolutionControl) || this.applyRefreshRule(moduleResolutionControl)) {
            return moduleResolutionControl;
        }
        for (Action rule : this.moduleCacheRules) {
            rule.execute((Object)moduleResolutionControl);
            if (!moduleResolutionControl.ruleMatch()) continue;
            break;
        }
        return moduleResolutionControl;
    }

    private boolean applyOfflineRule(ResolutionControl<?, ?> resolutionControl) {
        if (this.offline) {
            resolutionControl.useCachedResult();
            return true;
        }
        return false;
    }

    private boolean applyRefreshRule(ResolutionControl<?, ?> resolutionControl) {
        if (this.refresh) {
            resolutionControl.refresh();
            return true;
        }
        return false;
    }

    private class CachedDependencyResolutionControl
    extends AbstractResolutionControl<ModuleIdentifier, Set<ModuleVersionIdentifier>>
    implements DependencyResolutionControl {
        private CachedDependencyResolutionControl(ModuleIdentifier request, Set<ModuleVersionIdentifier> result, long ageMillis, long keepForMillis) {
            super(request, result, ageMillis, keepForMillis);
        }
    }

    private static class CachedModuleResolutionControl
    extends AbstractResolutionControl<ModuleVersionIdentifier, ResolvedModuleVersion>
    implements ModuleResolutionControl {
        private final boolean changing;

        private CachedModuleResolutionControl(ModuleVersionIdentifier moduleVersionId, ResolvedModuleVersion cachedVersion, boolean changing, long ageMillis, long keepForMillis) {
            super(moduleVersionId, cachedVersion, ageMillis, keepForMillis);
            this.changing = changing;
        }

        @Override
        public boolean isChanging() {
            return this.changing;
        }
    }

    private static class CachedArtifactResolutionControl
    extends AbstractResolutionControl<ModuleComponentArtifactMetadata, File>
    implements ArtifactResolutionControl {
        private final boolean belongsToChangingModule;

        private CachedArtifactResolutionControl(ModuleComponentArtifactMetadata artifact, File cachedResult, long ageMillis, long keepForMillis, boolean belongsToChangingModule) {
            super(artifact, cachedResult, ageMillis, keepForMillis);
            this.belongsToChangingModule = belongsToChangingModule;
        }

        @Override
        public boolean belongsToChangingModule() {
            return this.belongsToChangingModule;
        }
    }

    private static abstract class AbstractResolutionControl<A, B>
    implements ResolutionControl<A, B>,
    CacheExpirationControl.Expiry {
        private final A request;
        private final B cachedResult;
        private final long ageMillis;
        private long keepForMillis;
        private boolean ruleMatch;
        private boolean mustCheck;

        private AbstractResolutionControl(A request, B cachedResult, long ageMillis, long keepForMillis) {
            this.request = request;
            this.cachedResult = cachedResult;
            this.ageMillis = AbstractResolutionControl.correctForClockShift(ageMillis);
            this.keepForMillis = keepForMillis;
        }

        private static long correctForClockShift(long ageMillis) {
            if (ageMillis < 0L) {
                return 1L;
            }
            return ageMillis;
        }

        @Override
        public A getRequest() {
            return this.request;
        }

        @Override
        public B getCachedResult() {
            return this.cachedResult;
        }

        @Override
        public void cacheFor(int value, TimeUnit units) {
            this.keepForMillis = TimeUnit.MILLISECONDS.convert(value, units);
            this.setMustCheck(this.ageMillis > this.keepForMillis);
        }

        @Override
        public void useCachedResult() {
            this.setMustCheck(false);
        }

        @Override
        public void refresh() {
            this.setMustCheck(true);
        }

        private void setMustCheck(boolean val) {
            this.ruleMatch = true;
            this.mustCheck = val;
        }

        public boolean ruleMatch() {
            return this.ruleMatch;
        }

        @Override
        public Duration getKeepFor() {
            if (this.mustCheck && this.ageMillis > 0L) {
                return Duration.ZERO;
            }
            if (this.keepForMillis == Long.MAX_VALUE) {
                return Duration.ofMillis(Long.MAX_VALUE);
            }
            return Duration.ofMillis(Math.max(0L, this.keepForMillis - this.ageMillis));
        }

        @Override
        public boolean isMustCheck() {
            return this.mustCheck && this.ageMillis > 0L;
        }
    }
}

