/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.menubuilders.menu;

import java.awt.Component;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.IFreeplaneAction;
import org.freeplane.core.ui.components.JAutoCheckBoxMenuItem;
import org.freeplane.core.ui.components.JFreeplaneMenuItem;
import org.freeplane.core.ui.menubuilders.action.AcceleratebleActionProvider;
import org.freeplane.core.ui.menubuilders.action.IAcceleratorMap;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryAccessor;
import org.freeplane.core.ui.menubuilders.generic.ResourceAccessor;
import org.freeplane.core.ui.menubuilders.menu.ComponentProvider;
import org.freeplane.core.ui.menubuilders.menu.IconReplacer;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.HtmlUtils;

public class MenuActionComponentProvider
implements ComponentProvider {
    private IAcceleratorMap accelerators;
    private AcceleratebleActionProvider acceleratebleActionProvider;
    private EntryAccessor entryAccessor;

    public MenuActionComponentProvider(IAcceleratorMap accelerators, AcceleratebleActionProvider acceleratebleActionProvider, ResourceAccessor resourceAccessor) {
        this.accelerators = accelerators;
        this.acceleratebleActionProvider = acceleratebleActionProvider;
        this.entryAccessor = new EntryAccessor(resourceAccessor);
    }

    @Override
    public Component createComponent(Entry entry) {
        AFreeplaneAction action = this.entryAccessor.getAction(entry);
        if (action != null) {
            String toolTipText;
            IFreeplaneAction wrappedAction = this.acceleratebleActionProvider.wrap(action);
            JMenuItem actionComponent = action.isSelectable() ? new JAutoCheckBoxMenuItem(wrappedAction) : new JFreeplaneMenuItem(wrappedAction);
            KeyStroke accelerator = this.accelerators.getAccelerator(action);
            actionComponent.setAccelerator(accelerator);
            if (this.entryAccessor.shouldRemoveMenuIcon(entry)) {
                actionComponent.setIcon(null);
            } else {
                IconReplacer.replaceByScaledImageIcon(actionComponent);
            }
            if (Compat.isMacOsX() && HtmlUtils.isHtml(toolTipText = actionComponent.getToolTipText())) {
                actionComponent.setToolTipText(HtmlUtils.htmlToPlain(toolTipText, true, true));
            }
            return actionComponent;
        }
        if (entry.builders().contains("separator")) {
            return new JPopupMenu.Separator();
        }
        return null;
    }
}

