/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.jobs;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

abstract class DataSourceUpdaterJob
extends AbstractJob {
    private static final Set<String> activeDataSources = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInProcess(DBPDataSourceContainer ds) {
        Set<String> set = activeDataSources;
        synchronized (set) {
            return activeDataSources.contains(ds.getId());
        }
    }

    public DataSourceUpdaterJob(String name) {
        super(name);
    }

    public abstract DBPDataSource getDataSource();

    protected abstract IStatus updateDataSource(DBRProgressMonitor var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected IStatus run(@NotNull DBRProgressMonitor monitor) {
        if (this.getDataSource() == null) {
            return Status.CANCEL_STATUS;
        }
        String dsId = this.getDataSource().getContainer().getId();
        IStatus iStatus = activeDataSources;
        synchronized (iStatus) {
            if (activeDataSources.contains(dsId)) {
                return Status.CANCEL_STATUS;
            }
            activeDataSources.add(dsId);
        }
        try {
            iStatus = this.updateDataSource(monitor);
            return iStatus;
        }
        finally {
            Set<String> set = activeDataSources;
            synchronized (set) {
                activeDataSources.remove(dsId);
            }
        }
    }
}

