/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.erd.notation.idef1x;

import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.swt.graphics.Color;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.erd.ERDAssociation;
import org.jkiss.dbeaver.model.erd.ERDEntity;
import org.jkiss.dbeaver.model.erd.ERDUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.ui.editors.erd.notations.ERDNotation;
import org.jkiss.dbeaver.ui.editors.erd.notations.ERDNotationBase;
import org.jkiss.dbeaver.ui.editors.erd.part.AssociationPart;
import org.jkiss.dbeaver.ui.editors.erd.router.ERDConnectionRouterDescriptor;
import org.jkiss.dbeaver.ui.editors.erd.router.ERDConnectionRouterRegistry;

public class IDEF1XDiagramNotation
extends ERDNotationBase
implements ERDNotation {
    @Override
    public void applyNotationForArrows(@NotNull DBRProgressMonitor monitor, @NotNull PolylineConnection conn, @NotNull ERDAssociation association, @NotNull Color bckColor, @NotNull Color frgColor) {
        boolean identifying = ERDUtils.isIdentifyingAssociation((ERDAssociation)association);
        DBSEntityConstraintType constraintType = ((DBSEntityAssociation)association.getObject()).getConstraintType();
        if (constraintType == DBSEntityConstraintType.INHERITANCE) {
            PolygonDecoration srcDec = new PolygonDecoration();
            srcDec.setTemplate(PolygonDecoration.TRIANGLE_TIP);
            srcDec.setFill(true);
            srcDec.setBackgroundColor(bckColor);
            conn.setTargetDecoration((RotatableDecoration)srcDec);
        } else if (constraintType.isAssociation() && association.getSourceEntity() instanceof ERDEntity && association.getTargetEntity() instanceof ERDEntity) {
            AssociationPart.CircleDecoration sourceDecor = new AssociationPart.CircleDecoration();
            sourceDecor.setRadius(4);
            sourceDecor.setFill(true);
            sourceDecor.setBackgroundColor(frgColor);
            conn.setSourceDecoration((RotatableDecoration)sourceDecor);
            if (ERDUtils.isOptionalAssociation((ERDAssociation)association)) {
                AssociationPart.RhombusDecoration targetDecor = new AssociationPart.RhombusDecoration();
                targetDecor.setBackgroundColor(bckColor);
                conn.setTargetDecoration((RotatableDecoration)targetDecor);
            }
        }
        conn.setLineWidth(1);
        if (!identifying || constraintType.isLogical()) {
            float[] fArray;
            ERDConnectionRouterDescriptor defConnectionRouter = ERDConnectionRouterRegistry.getInstance().getActiveRouter();
            if (defConnectionRouter.supportedAttributeAssociation()) {
                conn.setLineStyle(6);
            } else {
                conn.setLineStyle(3);
            }
            if (constraintType.isLogical()) {
                float[] fArray2 = new float[1];
                fArray = fArray2;
                fArray2[0] = 4.0f;
            } else {
                float[] fArray3 = new float[1];
                fArray = fArray3;
                fArray3[0] = 5.0f;
            }
            conn.setLineDash(fArray);
        }
    }

    @Override
    public void applyNotationForEntities(@NotNull PolylineConnection conn, @NotNull ERDAssociation association, @NotNull Color bckColor, @NotNull Color frgColor) {
    }

    @Override
    public double getIndentation() {
        return 20.0;
    }
}

