/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model.lock;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseDataSource;
import org.jkiss.dbeaver.ext.altibase.model.lock.AltibaseLock;
import org.jkiss.dbeaver.ext.altibase.model.lock.AltibaseLockItem;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.admin.locks.DBAServerLockManager;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.admin.locks.LockGraphManager;

public class AltibaseLockManager
extends LockGraphManager
implements DBAServerLockManager<AltibaseLock, AltibaseLockItem> {
    public static final String sidHold = "hsid";
    public static final String sidWait = "wsid";
    private static final String LOCK_QUERY = "SELECT w.id AS w_sid ,w.client_pid AS w_pid ,w.trans_id AS w_txid ,w.db_username AS w_user_name ,wobj.schema_name AS w_obj_schema ,wobj.obj_name AS w_obj_name ,wobj.stmt AS w_query ,h.id AS h_sid ,h.client_pid AS h_pid ,h.trans_id AS h_txid ,h.db_username AS h_user_name ,stmt.query AS h_query FROM v$lock_wait vlw LEFT OUTER JOIN ( SELECT * FROM v$session ) w ON vlw.trans_id = w.trans_id LEFT OUTER JOIN ( SELECT u.user_name AS schema_name ,t.table_name AS obj_name ,ls.query AS stmt ,l.trans_id FROM v$lock l ,v$lock_statement ls ,system_.sys_tables_ t ,system_.sys_users_ u WHERE t.table_oid = l.table_oid AND u.user_id = t.user_id AND l.trans_id = ls.tx_id ) wobj ON vlw.trans_id = wobj.trans_id LEFT OUTER JOIN ( SELECT ss.* FROM v$session ss ,v$lock l WHERE ss.trans_id = l.trans_id AND l.is_grant = 1 ) h ON vlw.wait_for_trans_id = h.trans_id LEFT OUTER JOIN ( SELECT  s.*  FROM  v$statement s ) stmt ON h.id = stmt.session_id";
    private static final String LOCK_ITEM_QUERY = "SELECT  lock_desc, lock_cnt, tbs_id, table_oid, dbf_id, CASE2 (ls.lock_item_type  = 'TBL','TABLE',ls.lock_item_type) AS locked_obj_type, tbs.name AS tbs_name FROM  v$lock_statement ls LEFT OUTER JOIN (SELECT * FROM v$tablespaces) tbs ON tbs.id = ls.tbs_id WHERE  session_id = ?";
    private final AltibaseDataSource dataSource;

    public AltibaseLockManager(AltibaseDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    public Map<Object, AltibaseLock> getLocks(DBCSession session, Map<String, Object> options) throws DBException {
        try {
            HashMap<Object, AltibaseLock> locks = new HashMap<Object, AltibaseLock>(10);
            String sql = LOCK_QUERY;
            Throwable throwable = null;
            Object var6_8 = null;
            try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement(sql);){
                Throwable throwable2 = null;
                Object var9_13 = null;
                try (JDBCResultSet dbResult = dbStat.executeQuery();){
                    while (dbResult.next()) {
                        AltibaseLock l = new AltibaseLock((ResultSet)dbResult, this.dataSource);
                        locks.put(l.getId(), l);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
            super.buildGraphs(locks);
            return locks;
        }
        catch (SQLException e) {
            throw new DBDatabaseException((Throwable)e, session.getDataSource());
        }
    }

    public void alterSession(DBCSession session, AltibaseLock lock, Map<String, Object> options) throws DBException {
        try {
            String sql = String.format("ALTER DATABASE %s SESSION CLOSE %s", this.dataSource.getDbName((JDBCSession)session), lock.getWait_sid());
            Throwable throwable = null;
            Object var6_8 = null;
            try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement(sql);){
                dbStat.execute();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBDatabaseException((Throwable)e, session.getDataSource());
        }
    }

    public Class<AltibaseLock> getLocksType() {
        return AltibaseLock.class;
    }

    public Collection<AltibaseLockItem> getLockItems(DBCSession session, Map<String, Object> options) throws DBException {
        try {
            ArrayList<AltibaseLockItem> locks = new ArrayList<AltibaseLockItem>();
            String sql = LOCK_ITEM_QUERY;
            Throwable throwable = null;
            Object var6_8 = null;
            try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement(sql);){
                String otype = (String)options.get("type");
                switch (otype) {
                    case "wait": {
                        dbStat.setInt(1, ((Integer)options.get(sidWait)).intValue());
                        break;
                    }
                    case "hold": {
                        dbStat.setInt(1, ((Integer)options.get(sidHold)).intValue());
                        break;
                    }
                    default: {
                        return locks;
                    }
                }
                Object object = null;
                Object var10_14 = null;
                try (JDBCResultSet dbResult = dbStat.executeQuery();){
                    while (dbResult.next()) {
                        locks.add(new AltibaseLockItem((ResultSet)dbResult));
                    }
                }
                catch (Throwable throwable2) {
                    if (object == null) {
                        object = throwable2;
                    } else if (object != throwable2) {
                        ((Throwable)object).addSuppressed(throwable2);
                    }
                    throw object;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            return locks;
        }
        catch (SQLException e) {
            throw new DBDatabaseException((Throwable)e, session.getDataSource());
        }
    }
}

