# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "network watcher show-topology",
)
class ShowTopology(AAZCommand):
    """Get the network topology of a resource group, virtual network or subnet.

    For more information about using network topology visit https://learn.microsoft.com/en-us/azure/network-watcher/view-network-topology.

    :example: Use show-topology to get the topology of resources within a resource group.
        az network watcher show-topology -g MyResourceGroup
    """

    _aaz_info = {
        "version": "2022-01-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.network/networkwatchers/{}/topology", "2022-01-01"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.watcher_name = AAZStrArg(
            options=["--watcher-name"],
            help="Name of the network watcher.",
            required=True,
            id_part="name",
        )
        _args_schema.watcher_rg = AAZResourceGroupNameArg(
            options=["--watcher-rg"],
            help="Name of the resource group the watcher is in.",
            required=True,
        )

        # define Arg Group "Target"

        _args_schema = cls._args_schema
        _args_schema.resource_group_name = AAZStrArg(
            options=["--resource-group-name"],
            arg_group="Target",
            help="Name of the target resource group to perform topology on.",
        )
        _args_schema.subnet = AAZStrArg(
            options=["--subnet"],
            arg_group="Target",
            help="Name or ID of the subnet to target. If name is used, --vnet NAME must also be supplied.",
        )
        _args_schema.vnet = AAZStrArg(
            options=["--vnet"],
            arg_group="Target",
            help="Name or ID of the virtual network to target.",
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.NetworkWatchersGetTopology(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class NetworkWatchersGetTopology(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/topology",
                **self.url_parameters
            )

        @property
        def method(self):
            return "POST"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "networkWatcherName", self.ctx.args.watcher_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.watcher_rg,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2022-01-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("targetResourceGroupName", AAZStrType, ".resource_group_name")
            _builder.set_prop("targetSubnet", AAZObjectType)
            _builder.set_prop("targetVirtualNetwork", AAZObjectType)

            target_subnet = _builder.get(".targetSubnet")
            if target_subnet is not None:
                target_subnet.set_prop("id", AAZStrType, ".subnet")

            target_virtual_network = _builder.get(".targetVirtualNetwork")
            if target_virtual_network is not None:
                target_virtual_network.set_prop("id", AAZStrType, ".vnet")

            return self.serialize_content(_content_value)

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.created_date_time = AAZStrType(
                serialized_name="createdDateTime",
                flags={"read_only": True},
            )
            _schema_on_200.id = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.last_modified = AAZStrType(
                serialized_name="lastModified",
                flags={"read_only": True},
            )
            _schema_on_200.resources = AAZListType()

            resources = cls._schema_on_200.resources
            resources.Element = AAZObjectType()

            _element = cls._schema_on_200.resources.Element
            _element.associations = AAZListType()
            _element.id = AAZStrType()
            _element.location = AAZStrType()
            _element.name = AAZStrType()

            associations = cls._schema_on_200.resources.Element.associations
            associations.Element = AAZObjectType()

            _element = cls._schema_on_200.resources.Element.associations.Element
            _element.association_type = AAZStrType(
                serialized_name="associationType",
            )
            _element.name = AAZStrType()
            _element.resource_id = AAZStrType(
                serialized_name="resourceId",
            )

            return cls._schema_on_200


class _ShowTopologyHelper:
    """Helper class for ShowTopology"""


__all__ = ["ShowTopology"]
