﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/kinesisanalyticsv2/KinesisAnalyticsV2_EXPORTS.h>
#include <aws/kinesisanalyticsv2/model/InputDescription.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace KinesisAnalyticsV2 {
namespace Model {
class AddApplicationInputResult {
 public:
  AWS_KINESISANALYTICSV2_API AddApplicationInputResult() = default;
  AWS_KINESISANALYTICSV2_API AddApplicationInputResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_KINESISANALYTICSV2_API AddApplicationInputResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the application.</p>
   */
  inline const Aws::String& GetApplicationARN() const { return m_applicationARN; }
  template <typename ApplicationARNT = Aws::String>
  void SetApplicationARN(ApplicationARNT&& value) {
    m_applicationARNHasBeenSet = true;
    m_applicationARN = std::forward<ApplicationARNT>(value);
  }
  template <typename ApplicationARNT = Aws::String>
  AddApplicationInputResult& WithApplicationARN(ApplicationARNT&& value) {
    SetApplicationARN(std::forward<ApplicationARNT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Provides the current application version.</p>
   */
  inline long long GetApplicationVersionId() const { return m_applicationVersionId; }
  inline void SetApplicationVersionId(long long value) {
    m_applicationVersionIdHasBeenSet = true;
    m_applicationVersionId = value;
  }
  inline AddApplicationInputResult& WithApplicationVersionId(long long value) {
    SetApplicationVersionId(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Describes the application input configuration. </p>
   */
  inline const Aws::Vector<InputDescription>& GetInputDescriptions() const { return m_inputDescriptions; }
  template <typename InputDescriptionsT = Aws::Vector<InputDescription>>
  void SetInputDescriptions(InputDescriptionsT&& value) {
    m_inputDescriptionsHasBeenSet = true;
    m_inputDescriptions = std::forward<InputDescriptionsT>(value);
  }
  template <typename InputDescriptionsT = Aws::Vector<InputDescription>>
  AddApplicationInputResult& WithInputDescriptions(InputDescriptionsT&& value) {
    SetInputDescriptions(std::forward<InputDescriptionsT>(value));
    return *this;
  }
  template <typename InputDescriptionsT = InputDescription>
  AddApplicationInputResult& AddInputDescriptions(InputDescriptionsT&& value) {
    m_inputDescriptionsHasBeenSet = true;
    m_inputDescriptions.emplace_back(std::forward<InputDescriptionsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  AddApplicationInputResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_applicationARN;

  long long m_applicationVersionId{0};

  Aws::Vector<InputDescription> m_inputDescriptions;

  Aws::String m_requestId;
  bool m_applicationARNHasBeenSet = false;
  bool m_applicationVersionIdHasBeenSet = false;
  bool m_inputDescriptionsHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace KinesisAnalyticsV2
}  // namespace Aws
