/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.unresolvedReference;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyCustomType;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.PyCustomMember;
import com.jetbrains.python.codeInsight.PySubstitutionChunkReference;
import com.jetbrains.python.codeInsight.controlflow.PyDataFlowKt;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.documentation.docstrings.DocStringParameterReference;
import com.jetbrains.python.documentation.docstrings.DocStringTypeReference;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.AddFieldQuickFix;
import com.jetbrains.python.inspections.quickfix.AddFunctionQuickFix;
import com.jetbrains.python.inspections.quickfix.AddMethodQuickFix;
import com.jetbrains.python.inspections.quickfix.CreateClassQuickFix;
import com.jetbrains.python.inspections.quickfix.PyRenameUnresolvedRefQuickFix;
import com.jetbrains.python.inspections.quickfix.UnresolvedRefCreateFunctionQuickFix;
import com.jetbrains.python.inspections.quickfix.UnresolvedRefTrueFalseQuickFix;
import com.jetbrains.python.inspections.quickfix.UnresolvedReferenceAddParameterQuickFix;
import com.jetbrains.python.inspections.quickfix.UnresolvedReferenceAddSelfQuickFix;
import com.jetbrains.python.inspections.unresolvedReference.PyPackageInstallAllProblemInfo;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PsiReferenceEx;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratable;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReferenceOwner;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTryExceptStatement;
import com.jetbrains.python.psi.PyTryPart;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyCallExpressionNavigator;
import com.jetbrains.python.psi.impl.PyImportStatementNavigator;
import com.jetbrains.python.psi.impl.PyImportedModule;
import com.jetbrains.python.psi.impl.references.PyFromImportNameReference;
import com.jetbrains.python.psi.impl.references.PyImportReference;
import com.jetbrains.python.psi.impl.references.PyOperatorReference;
import com.jetbrains.python.psi.impl.references.hasattr.PyHasAttrHelper;
import com.jetbrains.python.psi.impl.stubs.PyVersionSpecificStubBaseKt;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassMembersProvider;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyFunctionType;
import com.jetbrains.python.psi.types.PyFunctionTypeImpl;
import com.jetbrains.python.psi.types.PyImportedModuleType;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyStructuralType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyTypeVarType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.PyUnsafeUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class PyUnresolvedReferencesVisitor
extends PyInspectionVisitor {
    private final ImmutableSet<String> myIgnoredIdentifiers;
    private final Version myVersion;
    private volatile Boolean myIsEnabled;
    protected final List<PyPackageInstallAllProblemInfo> myUnresolvedRefs;

    protected PyUnresolvedReferencesVisitor(@Nullable ProblemsHolder holder, @NotNull List<String> ignoredIdentifiers, @NotNull TypeEvalContext context, @NotNull LanguageLevel languageLevel) {
        if (ignoredIdentifiers == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(1);
        }
        if (languageLevel == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(2);
        }
        super(holder, context);
        this.myIsEnabled = null;
        this.myUnresolvedRefs = Collections.synchronizedList(new ArrayList());
        this.myIgnoredIdentifiers = ImmutableSet.copyOf(ignoredIdentifiers);
        this.myVersion = new Version(languageLevel.getMajorVersion(), languageLevel.getMinorVersion(), 0);
    }

    public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
        if (node == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(3);
        }
        this.checkSlotsAndProperties((PyQualifiedExpression)node);
    }

    private void checkSlotsAndProperties(PyQualifiedExpression node) {
        PyType type;
        PyExpression qualifier = node.getQualifier();
        String attrName = node.getReferencedName();
        if (qualifier != null && attrName != null && (type = this.myTypeEvalContext.getType((PyTypedElement)qualifier)) instanceof PyClassType && !((PyClassType)type).isAttributeWritable(attrName, this.myTypeEvalContext)) {
            ASTNode nameNode = node.getNameElement();
            PyQualifiedExpression e = nameNode != null ? nameNode.getPsi() : node;
            this.registerProblem((PsiElement)e, PyPsiBundle.message("INSP.unresolved.refs.class.object.has.no.attribute", type.getName(), attrName));
        }
    }

    public void visitPyElement(@NotNull PyElement node) {
        if (node == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(4);
        }
        super.visitPyElement(node);
        if (node instanceof PyReferenceOwner) {
            PyReferenceOwner referenceOwner = (PyReferenceOwner)node;
            PyResolveContext resolveContext = PyResolveContext.defaultContext((TypeEvalContext)this.myTypeEvalContext);
            this.processReference(node, (PsiReference)referenceOwner.getReference(resolveContext));
        } else {
            for (PsiReference reference : node.getReferences()) {
                this.processReference(node, reference);
            }
        }
    }

    private void processReference(@NotNull PyElement node, @Nullable PsiReference reference) {
        boolean unresolved;
        if (node == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(5);
        }
        if (!this.isEnabled((PsiElement)node) || reference == null || reference.isSoft()) {
            return;
        }
        PyExceptPart guard = PyUnresolvedReferencesVisitor.getImportErrorGuard(node);
        if (guard != null) {
            return;
        }
        if (node instanceof PyQualifiedExpression) {
            PyQualifiedExpression qExpr = (PyQualifiedExpression)node;
            PyExpression qualifier = qExpr.getQualifier();
            String name = node.getName();
            if (qualifier != null && name != null && PyHasAttrHelper.INSTANCE.getNamesFromHasAttrs((PsiElement)node, qualifier).contains(name)) {
                return;
            }
        }
        PsiElement target = null;
        if (reference instanceof PsiPolyVariantReference) {
            PsiPolyVariantReference poly = (PsiPolyVariantReference)reference;
            ResolveResult[] resolveResults = poly.multiResolve(false);
            unresolved = resolveResults.length == 0;
            for (ResolveResult resolveResult : resolveResults) {
                if (target != null || !resolveResult.isValidResult()) continue;
                target = resolveResult.getElement();
            }
        } else {
            target = reference.resolve();
            boolean bl = unresolved = target == null;
        }
        if (unresolved) {
            boolean ignoreUnresolved;
            boolean bl = ignoreUnresolved = this.ignoreUnresolved(node, reference) || !PyVersionSpecificStubBaseKt.evaluateVersionsForElement((PsiElement)node).contains((Comparable)this.myVersion);
            if (!ignoreUnresolved) {
                HighlightSeverity severity;
                HighlightSeverity highlightSeverity = severity = reference instanceof PsiReferenceEx ? ((PsiReferenceEx)reference).getUnresolvedHighlightSeverity(this.myTypeEvalContext) : HighlightSeverity.ERROR;
                if (severity == null && this.isAwaitCallToImportedNonAsyncFunction(reference)) {
                    severity = HighlightSeverity.WEAK_WARNING;
                }
                if (severity == null) {
                    return;
                }
                this.registerUnresolvedReferenceProblem(node, reference, severity);
            }
        } else if (reference instanceof PyImportReference && target == reference.getElement().getContainingFile() && !PyUnresolvedReferencesVisitor.isContainingFileImportAllowed(node, (PsiFile)target)) {
            this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.unresolved.refs.import.resolves.to.its.containing.file", new Object[0]));
        } else if (PyUnionType.isStrictSemanticsEnabled() && node instanceof PyQualifiedExpression) {
            PyUnionType unionType;
            PyType unionMemberMissingAttr;
            PyType qualifierType;
            PyQualifiedExpression qualifiedExpression = (PyQualifiedExpression)node;
            String referencedName = qualifiedExpression.getReferencedName();
            PyExpression qualifier = qualifiedExpression.getQualifier();
            if (referencedName != null && qualifier != null && (qualifierType = this.myTypeEvalContext.getType((PyTypedElement)qualifier)) instanceof PyUnionType && (unionMemberMissingAttr = this.findStrictUnionMemberMissingAttribute(unionType = (PyUnionType)qualifierType, reference, referencedName)) != null) {
                String unionTypeRender = PythonDocumentationProvider.getTypeName(qualifierType, this.myTypeEvalContext);
                String unionMemberRender = PythonDocumentationProvider.getTypeName(unionMemberMissingAttr, this.myTypeEvalContext);
                this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.unresolved.refs.unresolved.attribute.in.union.type", unionMemberRender, unionTypeRender, referencedName), ProblemHighlightType.WEAK_WARNING, null, reference.getRangeInElement(), new LocalQuickFix[0]);
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private boolean isAwaitCallToImportedNonAsyncFunction(@NotNull PsiReference reference) {
        PyPrefixExpression prefixExpression;
        PsiElement psiElement;
        if (reference == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(6);
        }
        if ((psiElement = reference.getElement()) instanceof PyPrefixExpression && "__await__".equals((prefixExpression = (PyPrefixExpression)psiElement).getOperator().getSpecialMethodName()) && (psiElement = PyUnresolvedReferencesVisitor.getReferenceQualifier(reference)) instanceof PyCallExpression) {
            PyCallExpression callExpression = (PyCallExpression)psiElement;
            @NotNull @NotNull List callees = callExpression.multiResolveCalleeFunction(PyResolveContext.defaultContext((TypeEvalContext)this.myTypeEvalContext));
            if (callees.isEmpty()) {
                return false;
            }
            for (PyCallable callee : callees) {
                PyFunction pyFunction;
                if (!(callee instanceof PyFunction) || !(pyFunction = (PyFunction)callee).isAsync()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void registerUnresolvedReferenceProblem(@NotNull PyElement node, @NotNull PsiReference reference, @NotNull HighlightSeverity severity) {
        String refName;
        if (node == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(7);
        }
        if (reference == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(8);
        }
        if (severity == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(9);
        }
        if (reference instanceof DocStringTypeReference) {
            return;
        }
        String description = null;
        PsiElement element = reference.getElement();
        String text = element.getText();
        TextRange rangeInElement = reference.getRangeInElement();
        String refText = text;
        if (rangeInElement.getStartOffset() >= 0 && rangeInElement.getEndOffset() > 0) {
            refText = rangeInElement.substring(text);
        }
        String string = refName = element instanceof PyQualifiedExpression ? ((PyQualifiedExpression)element).getReferencedName() : refText;
        if (StringUtil.isEmpty((String)refName)) {
            return;
        }
        List<QualifiedName> qualifiedNames = PyUnresolvedReferencesVisitor.getCanonicalNames(reference, this.myTypeEvalContext);
        for (QualifiedName name : qualifiedNames) {
            String canonicalName = name.toString();
            for (String ignored : this.myIgnoredIdentifiers) {
                String prefix;
                if (!(ignored.endsWith(".*") ? canonicalName.startsWith(prefix = ignored.substring(0, ignored.length() - ".*".length())) : canonicalName.equals(ignored))) continue;
                return;
            }
        }
        if (this.myIgnoredIdentifiers.contains((Object)refName)) {
            return;
        }
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        if (element instanceof PyReferenceExpression) {
            PyReferenceExpression expr = (PyReferenceExpression)element;
            if (PyNames.COMPARISON_OPERATORS.contains(refName)) {
                return;
            }
            if (!expr.isQualified()) {
                if (PyDataFlowKt.isUnreachableForInspection((PsiElement)expr, this.myTypeEvalContext)) {
                    return;
                }
                ContainerUtil.addIfNotNull(fixes, (Object)PyUnresolvedReferencesVisitor.getTrueFalseQuickFix(refText));
                ContainerUtil.addAll(fixes, PyUnresolvedReferencesVisitor.getAddSelfFixes(this.myTypeEvalContext, node, expr));
                ContainerUtil.addIfNotNull(fixes, (Object)PyUnresolvedReferencesVisitor.getCreateFunctionQuickFix(expr));
                ContainerUtil.addIfNotNull(fixes, (Object)PyUnresolvedReferencesVisitor.getAddParameterQuickFix(refName, expr));
                fixes.add(new PyRenameUnresolvedRefQuickFix());
            }
            if (PyModuleType.getPossibleInstanceMembers().contains(refName)) {
                return;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.getParentOfType((PsiElement)node, PyImportElement.class), (Class[])new Class[]{PyTryExceptStatement.class, PyIfStatement.class}) != null) {
                severity = HighlightSeverity.WEAK_WARNING;
                description = PyPsiBundle.message("INSP.unresolved.refs.module.not.found", refText);
            }
        }
        if (reference instanceof PsiReferenceEx && description == null) {
            description = ((PsiReferenceEx)reference).getUnresolvedDescription();
        }
        if (description == null) {
            PyExpression qualifier;
            boolean markedQualified = false;
            if (element instanceof PyQualifiedExpression) {
                if ("__qualname__".equals(refText) && !LanguageLevel.forElement((PsiElement)element).isPython2()) {
                    return;
                }
                if (PyNames.COMPARISON_OPERATORS.contains(refName)) {
                    return;
                }
            }
            if ((qualifier = PyUnresolvedReferencesVisitor.getReferenceQualifier(reference)) != null) {
                PyType type = this.myTypeEvalContext.getType((PyTypedElement)qualifier);
                if (type != null) {
                    if (this.ignoreUnresolvedMemberForType(type, reference, refName) || this.isDeclaredInSlots(type, refName)) {
                        return;
                    }
                    ContainerUtil.addAll(fixes, this.getCreateMemberFromUsageFixes(type, reference, refText));
                    if (type instanceof PyClassType) {
                        PyClassType classType = (PyClassType)type;
                        if (reference instanceof PyOperatorReference) {
                            PyClassLikeType metaClassType;
                            String className = type.getName();
                            if (classType.isDefinition() && (metaClassType = classType.getMetaClassType(this.myTypeEvalContext, true)) != null) {
                                className = metaClassType.getName();
                            }
                            description = PyPsiBundle.message("INSP.unresolved.refs.class.does.not.define.operator", className, refName, ((PyOperatorReference)reference).getReadableOperatorName());
                        } else {
                            description = PyPsiBundle.message("INSP.unresolved.refs.unresolved.attribute.for.class", refText, type.getName());
                        }
                    } else {
                        PyType unionMemberWithoutAttr = this.findStrictUnionMemberMissingAttribute(type, reference, refName);
                        if (unionMemberWithoutAttr != null) {
                            String unionTypeRender = PythonDocumentationProvider.getTypeName(type, this.myTypeEvalContext);
                            String unionMemberRender = PythonDocumentationProvider.getTypeName(unionMemberWithoutAttr, this.myTypeEvalContext);
                            description = PyPsiBundle.message("INSP.unresolved.refs.unresolved.attribute.in.union.type", unionMemberRender, unionTypeRender, refName);
                            severity = HighlightSeverity.WEAK_WARNING;
                        } else {
                            description = PyPsiBundle.message("INSP.unresolved.refs.cannot.find.reference.in.type", refText, type.getName());
                        }
                    }
                    markedQualified = true;
                } else if (this.isAwaitCallToImportedNonAsyncFunction(reference)) {
                    description = PyPsiBundle.message("INSP.await.call.on.imported.untyped.function", qualifier.getText());
                    node = qualifier;
                    rangeInElement = TextRange.create((int)0, (int)qualifier.getTextRange().getLength());
                    markedQualified = true;
                }
            }
            if (!markedQualified) {
                description = PyPsiBundle.message("INSP.unresolved.refs.unresolved.reference", refText);
                ContainerUtil.addAll(fixes, this.getAutoImportFixes(node, reference, element));
                ContainerUtil.addIfNotNull(fixes, (Object)this.getCreateClassFix(refText, element));
            }
        }
        if (severity == HighlightSeverity.WARNING) {
            ProblemHighlightType markedQualified = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        }
        ProblemHighlightType hlType = severity == HighlightSeverity.WEAK_WARNING ? ProblemHighlightType.WEAK_WARNING : (severity == HighlightSeverity.ERROR ? ProblemHighlightType.GENERIC_ERROR : ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
        ContainerUtil.addAll(fixes, this.getImportStatementQuickFixes(element));
        ContainerUtil.addAll(fixes, this.getAddIgnoredIdentifierQuickFixes(qualifiedNames));
        List<LocalQuickFix> installPackageQuickFixes = this.getInstallPackageQuickFixes(node, reference, refName);
        boolean isAddedToInstallAllFix = false;
        if (!installPackageQuickFixes.isEmpty()) {
            ContainerUtil.addAll(fixes, installPackageQuickFixes);
            PyPackageInstallAllProblemInfo problemInfo = new PyPackageInstallAllProblemInfo((PsiElement)node, description, hlType, refName, fixes);
            this.myUnresolvedRefs.add(problemInfo);
            isAddedToInstallAllFix = true;
        }
        if (reference instanceof PySubstitutionChunkReference) {
            return;
        }
        this.getPluginQuickFixes(fixes, reference);
        if (!isAddedToInstallAllFix) {
            this.registerProblem((PsiElement)node, description, hlType, null, rangeInElement, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        }
    }

    private boolean isDeclaredInSlots(@NotNull PyType type, @NotNull String attrName) {
        if (type == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(10);
        }
        if (attrName == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(11);
        }
        return ((StreamEx)PyTypeUtil.toStream(type).select(PyClassType.class).map(PyClassType::getPyClass).flatMap(cls -> StreamEx.of((Object)cls).append((Collection)cls.getAncestorClasses(this.myTypeEvalContext))).nonNull().filter(c -> c.isNewStyleClass(this.myTypeEvalContext))).flatCollection(PyClass::getOwnSlots).anyMatch(attrName::equals);
    }

    private boolean ignoreUnresolvedMemberForType(@Nullable PyType type, @NotNull PsiReference reference, @NotNull String name) {
        PyCallable callable;
        Object module;
        if (reference == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(12);
        }
        if (name == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(13);
        }
        if (type instanceof PyTypeVarType) {
            PyTypeVarType typeVarType = (PyTypeVarType)type;
            return typeVarType.getBound() == null && typeVarType.getDefaultType() == null && typeVarType.getConstraints().isEmpty();
        }
        if (type instanceof PyUnionType) {
            PyUnionType unionType = (PyUnionType)type;
            if (PyUnionType.isStrictSemanticsEnabled()) {
                return this.findStrictUnionMemberMissingAttribute(unionType, reference, name) == null;
            }
            return ContainerUtil.exists(unionType.getMembers(), member -> this.ignoreUnresolvedMemberForType((PyType)member, reference, name));
        }
        if (type instanceof PyUnsafeUnionType) {
            PyUnsafeUnionType weakUnionType = (PyUnsafeUnionType)type;
            return ContainerUtil.exists(weakUnionType.getMembers(), member -> this.ignoreUnresolvedMemberForType((PyType)member, reference, name));
        }
        if (PyTypeChecker.isUnknown(type, this.myTypeEvalContext)) {
            return true;
        }
        if (type instanceof PyStructuralType && ((PyStructuralType)type).isInferredFromUsages()) {
            return true;
        }
        if (type instanceof PyImportedModuleType && ((PyImportedModule)((Object)(module = ((PyImportedModuleType)type).getImportedModule()))).resolve() == null) {
            return true;
        }
        if (type instanceof PyCustomType) {
            module = ((PyCustomType)type).getTypesToMimic().iterator();
            while (module.hasNext()) {
                PyClassLikeType mimic = (PyClassLikeType)module.next();
                if (!(mimic instanceof PyClassType) || !PyUtil.hasUnresolvedAncestors(((PyClassType)mimic).getPyClass(), this.myTypeEvalContext)) continue;
                return true;
            }
        }
        if (type instanceof PyClassType) {
            PyClass cls = ((PyClassType)type).getPyClass();
            if (PyTypeChecker.overridesGetAttr(cls, this.myTypeEvalContext)) {
                return true;
            }
            if (cls.findProperty(name, true, this.myTypeEvalContext) != null) {
                return true;
            }
            if (PyUtil.hasUnresolvedAncestors(cls, this.myTypeEvalContext)) {
                return true;
            }
            if (this.isDecoratedAsDynamic(cls, true)) {
                return true;
            }
            if (PyUnresolvedReferencesVisitor.hasUnresolvedDynamicMember((PyClassType)type, reference, name, this.myTypeEvalContext)) {
                return true;
            }
            if (this.isAwaitOnGeneratorBasedCoroutine(name, reference, cls)) {
                return true;
            }
        }
        if (type instanceof PyFunctionTypeImpl && (callable = ((PyFunctionTypeImpl)type).getCallable()) instanceof PyFunction && PyKnownDecoratorUtil.hasUnknownOrUpdatingAttributesDecorator((PyDecoratable)((PyFunction)callable), this.myTypeEvalContext)) {
            return true;
        }
        if (type instanceof PyModuleType && (module = ((PyModuleType)type).getModule()).getLanguageLevel().isAtLeast(LanguageLevel.PYTHON37)) {
            return PyTypeChecker.definesGetAttr((PyFile)module, this.myTypeEvalContext);
        }
        for (PyInspectionExtension extension : PyInspectionExtension.EP_NAME.getExtensionList()) {
            if (!extension.ignoreUnresolvedMember(type, name, this.myTypeEvalContext)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private PyType findStrictUnionMemberMissingAttribute(@NotNull PyType type, @NotNull PsiReference ref, @NotNull String name) {
        PyUnionType unionType;
        block7: {
            block6: {
                if (type == null) {
                    PyUnresolvedReferencesVisitor.$$$reportNull$$$0(14);
                }
                if (ref == null) {
                    PyUnresolvedReferencesVisitor.$$$reportNull$$$0(15);
                }
                if (name == null) {
                    PyUnresolvedReferencesVisitor.$$$reportNull$$$0(16);
                }
                if (!(type instanceof PyUnionType)) break block6;
                unionType = (PyUnionType)type;
                if (PyUnionType.isStrictSemanticsEnabled()) break block7;
            }
            return null;
        }
        PyExpression location = PyUtil.as(ref.getElement(), PyExpression.class);
        return (PyType)ContainerUtil.find(unionType.getMembers(), t -> {
            if (t == null || this.ignoreUnresolvedMemberForType((PyType)t, ref, name)) {
                return false;
            }
            return ContainerUtil.isEmpty((Collection)t.resolveMember(name, location, AccessDirection.READ, this.getResolveContext()));
        });
    }

    private boolean isDecoratedAsDynamic(@NotNull PyClass cls, boolean inherited) {
        if (cls == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(17);
        }
        if (inherited) {
            if (this.isDecoratedAsDynamic(cls, false)) {
                return true;
            }
            for (PyClass base : cls.getAncestorClasses(this.myTypeEvalContext)) {
                if (base == null || !this.isDecoratedAsDynamic(base, false)) continue;
                return true;
            }
        } else {
            String docString = cls.getDocStringValue();
            if (docString != null && docString.contains("@DynamicAttrs")) {
                return true;
            }
        }
        return false;
    }

    private boolean isAwaitOnGeneratorBasedCoroutine(@NotNull String name, @NotNull PsiReference reference, @NotNull PyClass cls) {
        PyExpression receiver;
        if (name == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(18);
        }
        if (reference == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(19);
        }
        if (cls == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(20);
        }
        if ("__await__".equals(name) && reference instanceof PyOperatorReference && "typing.Generator".equals(cls.getQualifiedName()) && (receiver = ((PyOperatorReference)reference).getReceiver()) instanceof PyCallExpression) {
            return PyKnownDecoratorUtil.isResolvedToGeneratorBasedCoroutine((PyCallExpression)receiver, this.getResolveContext(), this.myTypeEvalContext);
        }
        return false;
    }

    private boolean isEnabled(@NotNull PsiElement anchor) {
        if (anchor == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(21);
        }
        if (this.myIsEnabled == null) {
            Boolean overridden = PyUnresolvedReferencesVisitor.overriddenUnresolvedReferenceInspection(anchor.getContainingFile());
            this.myIsEnabled = Objects.requireNonNullElse(overridden, true);
        }
        return this.myIsEnabled;
    }

    @Nullable
    private static Boolean overriddenUnresolvedReferenceInspection(@NotNull PsiFile file) {
        if (file == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(22);
        }
        return PyInspectionExtension.EP_NAME.getExtensionList().stream().map(e -> e.overrideUnresolvedReferenceInspection(file)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public void addInstallAllImports() {
        Set refNames = ContainerUtil.map2Set(this.myUnresolvedRefs, it -> it.getRefName());
        LocalQuickFix installAllPackageQuickFixes = this.getInstallAllPackagesQuickFix();
        for (PyPackageInstallAllProblemInfo unresolved : this.myUnresolvedRefs) {
            List<LocalQuickFix> quickFixes = unresolved.getFixes();
            if (refNames.size() > 1) {
                ContainerUtil.addIfNotNull(quickFixes, (Object)installAllPackageQuickFixes);
            }
            this.registerProblem(unresolved.getPsiElement(), unresolved.getDescriptionTemplate(), unresolved.getHighlightType(), null, quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        }
    }

    private boolean ignoreUnresolved(@NotNull PyElement node, @NotNull PsiReference reference) {
        if (node == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(23);
        }
        if (reference == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(24);
        }
        boolean ignoreUnresolved = false;
        for (PyInspectionExtension extension : PyInspectionExtension.EP_NAME.getExtensionList()) {
            if (!extension.ignoreUnresolvedReference(node, reference, this.myTypeEvalContext)) continue;
            ignoreUnresolved = true;
            break;
        }
        return ignoreUnresolved;
    }

    @Nullable
    private static PyExceptPart getImportErrorGuard(PyElement node) {
        PyTryExceptStatement tryExceptStatement;
        PyTryPart tryPart;
        PyImportStatementBase importStatement = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)node, PyImportStatementBase.class);
        if (importStatement != null && (tryPart = (PyTryPart)PsiTreeUtil.getParentOfType((PsiElement)node, PyTryPart.class)) != null && (tryExceptStatement = (PyTryExceptStatement)PsiTreeUtil.getParentOfType((PsiElement)tryPart, PyTryExceptStatement.class)) != null) {
            for (PyExceptPart exceptPart : tryExceptStatement.getExceptParts()) {
                PyExpression expr = exceptPart.getExceptClass();
                if (expr == null || !"ImportError".equals(expr.getName())) continue;
                return exceptPart;
            }
        }
        return null;
    }

    private static boolean isContainingFileImportAllowed(PyElement node, PsiFile target) {
        return PyImportStatementNavigator.getImportStatementByElement((PsiElement)node) == null && target.getName().equals("__init__.py");
    }

    @Nullable
    private static PyExpression getReferenceQualifier(@NotNull PsiReference reference) {
        PyReferenceExpression source;
        PyFromImportStatement statement;
        PyExpression qualifier;
        PsiElement element;
        if (reference == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(25);
        }
        if ((element = reference.getElement()) instanceof PyQualifiedExpression && (qualifier = ((PyQualifiedExpression)element).getQualifier()) != null) {
            return qualifier;
        }
        if (reference instanceof PyFromImportNameReference && (statement = (PyFromImportStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyFromImportStatement.class)) != null && (source = statement.getImportSource()) != null) {
            return source;
        }
        return null;
    }

    @NotNull
    private static List<QualifiedName> getCanonicalNames(@NotNull PsiReference reference, @NotNull TypeEvalContext context) {
        if (reference == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(26);
        }
        if (context == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(27);
        }
        PsiElement element = reference.getElement();
        SmartList result = new SmartList();
        if (reference instanceof PyOperatorReference && element instanceof PyQualifiedExpression) {
            PyType type2;
            PyExpression receiver = ((PyOperatorReference)reference).getReceiver();
            if (receiver != null && (type2 = context.getType((PyTypedElement)receiver)) instanceof PyClassType) {
                String methodName = ((PyQualifiedExpression)element).getReferencedName();
                ContainerUtil.addIfNotNull((Collection)result, (Object)PyUnresolvedReferencesVisitor.extractAttributeQNameFromClassType(methodName, (PyClassType)type2));
            }
        } else if (element instanceof PyReferenceExpression) {
            PyReferenceExpression expr = (PyReferenceExpression)element;
            PyExpression qualifier = expr.getQualifier();
            String exprName = expr.getName();
            if (exprName != null) {
                if (qualifier != null) {
                    PyType qualifierType = context.getType((PyTypedElement)qualifier);
                    PyTypeUtil.toStream(qualifierType).map(type -> {
                        QualifiedName path;
                        PyCallable callable;
                        String callableName;
                        if (type instanceof PyClassType) {
                            return PyUnresolvedReferencesVisitor.extractAttributeQNameFromClassType(exprName, (PyClassType)type);
                        }
                        if (type instanceof PyModuleType) {
                            PyFile file = ((PyModuleType)type).getModule();
                            QualifiedName name = QualifiedNameFinder.findCanonicalImportPath((PsiElement)file, element);
                            if (name != null) {
                                return name.append(exprName);
                            }
                        } else if (type instanceof PyImportedModuleType) {
                            QualifiedName path2;
                            PyImportedModule module = ((PyImportedModuleType)type).getImportedModule();
                            PsiElement resolved = module.resolve();
                            if (resolved != null && (path2 = QualifiedNameFinder.findCanonicalImportPath(resolved, element)) != null) {
                                return path2.append(exprName);
                            }
                        } else if (type instanceof PyFunctionType && (callableName = (callable = ((PyFunctionType)type).getCallable()).getName()) != null && (path = QualifiedNameFinder.findCanonicalImportPath((PsiElement)callable, element)) != null) {
                            return path.append(QualifiedName.fromComponents((String[])new String[]{callableName, exprName}));
                        }
                        return null;
                    }).nonNull().into((Collection)result);
                } else {
                    PsiElement parent = element.getParent();
                    if (parent instanceof PyImportElement) {
                        QualifiedName path;
                        PsiFileSystemItem resolved;
                        PyImportStatementBase importStmt = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)parent, PyImportStatementBase.class);
                        if (importStmt instanceof PyImportStatement) {
                            ContainerUtil.addIfNotNull((Collection)result, (Object)QualifiedName.fromComponents((String[])new String[]{exprName}));
                        } else if (importStmt instanceof PyFromImportStatement && (resolved = ((PyFromImportStatement)importStmt).resolveImportSource()) != null && (path = QualifiedNameFinder.findCanonicalImportPath((PsiElement)resolved, element)) != null) {
                            ContainerUtil.addIfNotNull((Collection)result, (Object)path.append(exprName));
                        }
                    } else {
                        QualifiedName path = QualifiedNameFinder.findCanonicalImportPath(element, element);
                        if (path != null) {
                            ContainerUtil.addIfNotNull((Collection)result, (Object)path.append(exprName));
                        }
                    }
                }
            }
        } else if (reference instanceof DocStringParameterReference) {
            ContainerUtil.addIfNotNull((Collection)result, (Object)QualifiedName.fromDottedString((String)reference.getCanonicalText()));
        }
        SmartList smartList = result;
        if (smartList == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(28);
        }
        return smartList;
    }

    private static QualifiedName extractAttributeQNameFromClassType(String exprName, PyClassType type) {
        String name = type.getClassQName();
        if (name != null) {
            return QualifiedName.fromDottedString((String)name).append(exprName);
        }
        return null;
    }

    @NotNull
    protected List<LocalQuickFix> getInstallPackageQuickFixes(@NotNull PyElement node, @NotNull PsiReference reference, String refName) {
        if (node == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(29);
        }
        if (reference == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(30);
        }
        List<LocalQuickFix> list = Collections.emptyList();
        if (list == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(31);
        }
        return list;
    }

    @Nullable
    protected LocalQuickFix getInstallAllPackagesQuickFix() {
        return null;
    }

    @Nullable
    private static LocalQuickFix getCreateFunctionQuickFix(@NotNull PyReferenceExpression expr) {
        PyCallExpression callExpression;
        if (expr == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(32);
        }
        if (!((callExpression = PyCallExpressionNavigator.getPyCallExpressionByCallee((PsiElement)expr)) == null || callExpression.getCallee() instanceof PyQualifiedExpression && ((PyQualifiedExpression)callExpression.getCallee()).getQualifier() != null)) {
            return new UnresolvedRefCreateFunctionQuickFix(expr);
        }
        return null;
    }

    @NotNull
    protected List<LocalQuickFix> getAddIgnoredIdentifierQuickFixes(List<QualifiedName> qualifiedNames) {
        List<LocalQuickFix> list = Collections.emptyList();
        if (list == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(33);
        }
        return list;
    }

    @NotNull
    protected List<LocalQuickFix> getImportStatementQuickFixes(PsiElement element) {
        List<LocalQuickFix> list = Collections.emptyList();
        if (list == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(34);
        }
        return list;
    }

    @Nullable
    private static LocalQuickFix getAddParameterQuickFix(String refName, PyReferenceExpression expr) {
        PyFunction parentFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)expr, PyFunction.class);
        PyDecorator decorator = (PyDecorator)PsiTreeUtil.getParentOfType((PsiElement)expr, PyDecorator.class);
        PyAnnotation annotation = (PyAnnotation)PsiTreeUtil.getParentOfType((PsiElement)expr, PyAnnotation.class);
        PyImportStatement importStatement = (PyImportStatement)PsiTreeUtil.getParentOfType((PsiElement)expr, PyImportStatement.class);
        if (parentFunction != null && decorator == null && annotation == null && importStatement == null) {
            return new UnresolvedReferenceAddParameterQuickFix(refName);
        }
        return null;
    }

    @Nullable
    private static LocalQuickFix getTrueFalseQuickFix(@NotNull String refText) {
        if (refText == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(35);
        }
        if (refText.equals("true") || refText.equals("false")) {
            return new UnresolvedRefTrueFalseQuickFix(refText);
        }
        return null;
    }

    @Nullable
    private LocalQuickFix getCreateClassFix(@NonNls String refText, PsiElement element) {
        if (refText.length() > 2 && Character.isUpperCase(refText.charAt(0)) && !StringUtil.toUpperCase((String)refText).equals(refText) && element instanceof PyQualifiedExpression) {
            PyFromImportStatement fromImport;
            PyExpression qualifier = ((PyQualifiedExpression)element).getQualifier();
            if (qualifier == null && (fromImport = (PyFromImportStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyFromImportStatement.class)) != null) {
                qualifier = fromImport.getImportSource();
            }
            PyFile destination = null;
            if (qualifier != null) {
                PyType type = this.myTypeEvalContext.getType((PyTypedElement)qualifier);
                if (type instanceof PyModuleType) {
                    destination = ((PyModuleType)type).getModule();
                } else {
                    return null;
                }
            }
            if (destination == null) {
                InjectedLanguageManager injectionManager = InjectedLanguageManager.getInstance((Project)element.getProject());
                PsiLanguageInjectionHost injectionHost = injectionManager.getInjectionHost(element);
                destination = ((PsiElement)ObjectUtils.chooseNotNull((Object)injectionHost, (Object)element)).getContainingFile();
            }
            return new CreateClassQuickFix(refText, (PsiFile)destination);
        }
        return null;
    }

    @NotNull
    private List<LocalQuickFix> getCreateMemberFromUsageFixes(PyType type, PsiReference reference, String refText) {
        ArrayList<LocalQuickFix> result = new ArrayList<LocalQuickFix>();
        PsiElement element = reference.getElement();
        if (type instanceof PyClassTypeImpl) {
            PyClass cls = ((PyClassType)type).getPyClass();
            if (!PyBuiltinCache.getInstance(element).isBuiltin((PsiElement)cls)) {
                if (element.getParent() instanceof PyCallExpression) {
                    result.add(new AddMethodQuickFix(refText, cls.getName(), true));
                } else if (!(reference instanceof PyOperatorReference)) {
                    result.add(new AddFieldQuickFix(refText, "None", type.getName(), true));
                }
            }
        } else if (type instanceof PyModuleType) {
            PyFile file = ((PyModuleType)type).getModule();
            LocalQuickFix createClassQuickFix = this.getCreateClassFix(refText, element);
            if (createClassQuickFix != null) {
                result.add(createClassQuickFix);
            } else {
                result.add(new AddFunctionQuickFix(refText, file.getName()));
            }
        }
        ArrayList<LocalQuickFix> arrayList = result;
        if (arrayList == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(36);
        }
        return arrayList;
    }

    @NotNull
    private static List<LocalQuickFix> getAddSelfFixes(TypeEvalContext typeEvalContext, PyElement node, PyReferenceExpression expr) {
        ArrayList<LocalQuickFix> result = new ArrayList<LocalQuickFix>();
        PyClass containedClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)node, PyClass.class);
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)node, PyFunction.class);
        if (containedClass != null && function != null) {
            PyParameter[] parameters = function.getParameterList().getParameters();
            if (parameters.length == 0) {
                List<LocalQuickFix> list = Collections.emptyList();
                if (list == null) {
                    PyUnresolvedReferencesVisitor.$$$reportNull$$$0(37);
                }
                return list;
            }
            String qualifier = parameters[0].getText();
            PyDecoratorList decoratorList = function.getDecoratorList();
            boolean isClassMethod = false;
            if (decoratorList != null) {
                for (PyDecorator decorator : decoratorList.getDecorators()) {
                    PyExpression callee = decorator.getCallee();
                    if (callee == null || !"classmethod".equals(callee.getText())) continue;
                    isClassMethod = true;
                }
            }
            for (PyTargetExpression target : containedClass.getInstanceAttributes()) {
                if (isClassMethod || !Comparing.strEqual((String)node.getName(), (String)target.getName())) continue;
                result.add((LocalQuickFix)new UnresolvedReferenceAddSelfQuickFix(expr, qualifier));
            }
            for (PyStatement statement : containedClass.getStatementList().getStatements()) {
                PyType type;
                PyExpression assignedValue;
                PyExpression lhsExpression;
                if (!(statement instanceof PyAssignmentStatement) || (lhsExpression = ((PyAssignmentStatement)statement).getLeftHandSideExpression()) == null || !lhsExpression.getText().equals(expr.getText()) || !((assignedValue = ((PyAssignmentStatement)statement).getAssignedValue()) instanceof PyCallExpression) || !((type = typeEvalContext.getType((PyTypedElement)assignedValue)) instanceof PyClassTypeImpl) || !((PyCallExpression)assignedValue).isCalleeText(new String[]{"property"})) continue;
                result.add((LocalQuickFix)new UnresolvedReferenceAddSelfQuickFix(expr, qualifier));
            }
            for (PyFunction method : containedClass.getMethods()) {
                if (!expr.getText().equals(method.getName())) continue;
                result.add((LocalQuickFix)new UnresolvedReferenceAddSelfQuickFix(expr, qualifier));
            }
        }
        ArrayList<LocalQuickFix> arrayList = result;
        if (arrayList == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(38);
        }
        return arrayList;
    }

    protected List<LocalQuickFix> getAutoImportFixes(PyElement node, PsiReference reference, PsiElement element) {
        return Collections.emptyList();
    }

    private static boolean hasUnresolvedDynamicMember(@NotNull PyClassType type, PsiReference reference, @NotNull String name, TypeEvalContext typeEvalContext) {
        if (type == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(39);
        }
        if (name == null) {
            PyUnresolvedReferencesVisitor.$$$reportNull$$$0(40);
        }
        ArrayList<PyClassType> types = new ArrayList<PyClassType>(Collections.singletonList(type));
        types.addAll((Collection<PyClassType>)FluentIterable.from((Iterable)type.getAncestorTypes(typeEvalContext)).filter(PyClassType.class).toList());
        for (PyClassType typeToCheck : types) {
            for (PyClassMembersProvider provider : PyClassMembersProvider.EP_NAME.getExtensionList()) {
                Collection resolveResult = provider.getMembers(typeToCheck, reference.getElement(), typeEvalContext);
                for (PyCustomMember member : resolveResult) {
                    if (!member.getName().equals(name)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @VisibleForTesting
    public void getPluginQuickFixes(List<LocalQuickFix> fixes, PsiReference reference) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 28, 31, 33, 34, 36, 37, 38 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredIdentifiers";
                break;
            }
            case 1: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 10: 
            case 14: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
            case 13: 
            case 16: 
            case 18: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 28: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesVisitor";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesVisitor";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalNames";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallPackageQuickFixes";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddIgnoredIdentifierQuickFixes";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportStatementQuickFixes";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateMemberFromUsageFixes";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddSelfFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitPyTargetExpression";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitPyElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processReference";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAwaitCallToImportedNonAsyncFunction";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerUnresolvedReferenceProblem";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isDeclaredInSlots";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "ignoreUnresolvedMemberForType";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findStrictUnionMemberMissingAttribute";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isDecoratedAsDynamic";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isAwaitOnGeneratorBasedCoroutine";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "overriddenUnresolvedReferenceInspection";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "ignoreUnresolved";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceQualifier";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalNames";
                break;
            }
            case 28: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: {
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getInstallPackageQuickFixes";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getCreateFunctionQuickFix";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getTrueFalseQuickFix";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "hasUnresolvedDynamicMember";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 28, 31, 33, 34, 36, 37, 38 -> new IllegalStateException(string);
        };
    }
}

