/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyChangeBaseClassQuickFix;
import com.jetbrains.python.inspections.quickfix.PyConvertToNewStyleQuickFix;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyOldStyleClassesInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyOldStyleClassesInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyOldStyleClassesInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, PyInspectionVisitor.getContext(session));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PyOldStyleClassesInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Visitor
    extends PyInspectionVisitor {
        Visitor(@Nullable ProblemsHolder holder, @NotNull TypeEvalContext context) {
            if (context == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, context);
        }

        public void visitPyClass(@NotNull PyClass node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            List expressions = node.getSuperClassTypes(this.myTypeEvalContext);
            ArrayList<PsiUpdateModCommandQuickFix> quickFixes = new ArrayList<PsiUpdateModCommandQuickFix>();
            quickFixes.add(new PyConvertToNewStyleQuickFix());
            if (!expressions.isEmpty()) {
                quickFixes.add(new PyChangeBaseClassQuickFix());
            }
            if (!node.isNewStyleClass(this.myTypeEvalContext)) {
                for (PyTargetExpression attr : node.getClassAttributes()) {
                    if (!"__slots__".equals(attr.getName())) continue;
                    this.registerProblem((PsiElement)attr, PyPsiBundle.message("INSP.oldstyle.class.slots", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                }
                for (PyFunction attr : node.getMethods()) {
                    if (!"__getattribute__".equals(attr.getName())) continue;
                    ASTNode nameNode = attr.getNameNode();
                    assert (nameNode != null);
                    this.registerProblem(nameNode.getPsi(), PyPsiBundle.message("INSP.oldstyle.class.getattribute", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                }
            }
        }

        public void visitPyCallExpression(@NotNull PyCallExpression node) {
            PyClass klass;
            if (node == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if ((klass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)node, PyClass.class)) != null && !klass.isNewStyleClass(this.myTypeEvalContext)) {
                PyExpression callee;
                List types = klass.getSuperClassTypes(this.myTypeEvalContext);
                for (PyClassLikeType type : types) {
                    if (type == null) {
                        return;
                    }
                    String qName = type.getClassQName();
                    if (qName != null && qName.contains("PyQt")) {
                        return;
                    }
                    if (type instanceof PyClassType) continue;
                    return;
                }
                ArrayList<PsiUpdateModCommandQuickFix> quickFixes = new ArrayList<PsiUpdateModCommandQuickFix>();
                quickFixes.add(new PyConvertToNewStyleQuickFix());
                if (!types.isEmpty()) {
                    quickFixes.add(new PyChangeBaseClassQuickFix());
                }
                if (PyUtil.isSuperCall(node) && (callee = node.getCallee()) != null) {
                    this.registerProblem((PsiElement)callee, PyPsiBundle.message("INSP.oldstyle.class.super", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyOldStyleClassesInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyClass";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyCallExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

