/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.ui.preview.PreviewLAFThemeStyles;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aBG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\u0006\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014\u00a8\u0006\u001b"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/PreviewStyleScheme;", "", "fontSize", "", "scale", "", "backgroundColor", "Ljava/awt/Color;", "foregroundColor", "linkActiveForegroundColor", "infoForegroundColor", "separatorColor", "fenceBackgroundColor", "<init>", "(IFLjava/awt/Color;Ljava/awt/Color;Ljava/awt/Color;Ljava/awt/Color;Ljava/awt/Color;Ljava/awt/Color;)V", "getFontSize", "()I", "getScale", "()F", "getBackgroundColor", "()Ljava/awt/Color;", "getForegroundColor", "getLinkActiveForegroundColor", "getInfoForegroundColor", "getSeparatorColor", "getFenceBackgroundColor", "Companion", "intellij.markdown"})
public final class PreviewStyleScheme {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int fontSize;
    private final float scale;
    @NotNull
    private final Color backgroundColor;
    @NotNull
    private final Color foregroundColor;
    @NotNull
    private final Color linkActiveForegroundColor;
    @NotNull
    private final Color infoForegroundColor;
    @NotNull
    private final Color separatorColor;
    @NotNull
    private final Color fenceBackgroundColor;

    public PreviewStyleScheme(int fontSize, float scale, @NotNull Color backgroundColor, @NotNull Color foregroundColor, @NotNull Color linkActiveForegroundColor, @NotNull Color infoForegroundColor, @NotNull Color separatorColor, @NotNull Color fenceBackgroundColor) {
        Intrinsics.checkNotNullParameter((Object)backgroundColor, (String)"backgroundColor");
        Intrinsics.checkNotNullParameter((Object)foregroundColor, (String)"foregroundColor");
        Intrinsics.checkNotNullParameter((Object)linkActiveForegroundColor, (String)"linkActiveForegroundColor");
        Intrinsics.checkNotNullParameter((Object)infoForegroundColor, (String)"infoForegroundColor");
        Intrinsics.checkNotNullParameter((Object)separatorColor, (String)"separatorColor");
        Intrinsics.checkNotNullParameter((Object)fenceBackgroundColor, (String)"fenceBackgroundColor");
        this.fontSize = fontSize;
        this.scale = scale;
        this.backgroundColor = backgroundColor;
        this.foregroundColor = foregroundColor;
        this.linkActiveForegroundColor = linkActiveForegroundColor;
        this.infoForegroundColor = infoForegroundColor;
        this.separatorColor = separatorColor;
        this.fenceBackgroundColor = fenceBackgroundColor;
    }

    public final int getFontSize() {
        return this.fontSize;
    }

    public final float getScale() {
        return this.scale;
    }

    @NotNull
    public final Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @NotNull
    public final Color getForegroundColor() {
        return this.foregroundColor;
    }

    @NotNull
    public final Color getLinkActiveForegroundColor() {
        return this.linkActiveForegroundColor;
    }

    @NotNull
    public final Color getInfoForegroundColor() {
        return this.infoForegroundColor;
    }

    @NotNull
    public final Color getSeparatorColor() {
        return this.separatorColor;
    }

    @NotNull
    public final Color getFenceBackgroundColor() {
        return this.fenceBackgroundColor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\u0014\u0010\b\u001a\u00020\t*\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/PreviewStyleScheme$Companion;", "", "<init>", "()V", "fromCurrentTheme", "Lorg/intellij/plugins/markdown/ui/preview/PreviewStyleScheme;", "obtainColorScheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "contrast", "Ljava/awt/Color;", "coefficient", "", "intellij.markdown"})
    @SourceDebugExtension(value={"SMAP\nPreviewStyleScheme.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreviewStyleScheme.kt\norg/intellij/plugins/markdown/ui/preview/PreviewStyleScheme$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,76:1\n42#2,3:77\n*S KotlinDebug\n*F\n+ 1 PreviewStyleScheme.kt\norg/intellij/plugins/markdown/ui/preview/PreviewStyleScheme$Companion\n*L\n41#1:77,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PreviewStyleScheme fromCurrentTheme() {
            EditorColorsScheme scheme = this.obtainColorScheme();
            Color color = scheme.getDefaultForeground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getDefaultForeground(...)");
            Color contrastedForeground = this.contrast(color, 0.1);
            Color color2 = UIUtil.getPanelBackground();
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getPanelBackground(...)");
            Color panelBackground = color2;
            Color color3 = JBUI.CurrentTheme.Link.Foreground.ENABLED;
            Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"ENABLED");
            Color linkActiveForeground = color3;
            JBColor jBColor = JBColor.namedColor((String)"Group.separatorColor", (Color)panelBackground);
            Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
            JBColor separatorColor = jBColor;
            JBColor jBColor2 = JBColor.namedColor((String)"Component.infoForeground", (Color)contrastedForeground);
            Intrinsics.checkNotNullExpressionValue((Object)jBColor2, (String)"namedColor(...)");
            JBColor infoForeground = jBColor2;
            JBColor markdownFenceBackground = new JBColor(new Color(212, 222, 231, 63), new Color(212, 222, 231, 25));
            int fontSize = PreviewLAFThemeStyles.INSTANCE.getDefaultFontSize();
            Color color4 = scheme.getDefaultBackground();
            Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"getDefaultBackground(...)");
            Color backgroundColor = color4;
            boolean $i$f$service = false;
            Class<UISettings> serviceClass$iv = UISettings.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            float scale = ((UISettings)object).getCurrentIdeScale();
            Color color5 = scheme.getDefaultForeground();
            Intrinsics.checkNotNullExpressionValue((Object)color5, (String)"getDefaultForeground(...)");
            return new PreviewStyleScheme(fontSize, scale, backgroundColor, color5, linkActiveForeground, (Color)infoForeground, (Color)separatorColor, (Color)markdownFenceBackground);
        }

        private final EditorColorsScheme obtainColorScheme() {
            EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
            Intrinsics.checkNotNull((Object)editorColorsManager, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl");
            EditorColorsManagerImpl manager = (EditorColorsManagerImpl)editorColorsManager;
            EditorColorsScheme editorColorsScheme = (EditorColorsScheme)manager.getSchemeManager().getActiveScheme();
            if (editorColorsScheme == null) {
                editorColorsScheme = (EditorColorsScheme)DefaultColorSchemesManager.Companion.getInstance().getFirstScheme();
            }
            return editorColorsScheme;
        }

        private final Color contrast(Color $this$contrast, double coefficient) {
            return new Color((int)(coefficient * (double)($this$contrast.getRed() - 128) + (double)128), (int)(coefficient * (double)($this$contrast.getGreen() - 128) + (double)128), (int)(coefficient * (double)($this$contrast.getBlue() - 128) + (double)128), $this$contrast.getAlpha());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

