/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal;

import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.UnresolvableConfigurationResult;
import org.gradle.internal.deprecation.DeprecatableConfiguration;
import org.jspecify.annotations.Nullable;

public class ConfigurationDetails {
    private final String name;
    private final @Nullable String description;
    private final boolean canBeResolved;
    private final @Nullable Provider<ResolvedComponentResult> resolutionResultRoot;
    private final @Nullable UnresolvableConfigurationResult unresolvableResult;

    public static ConfigurationDetails of(Configuration configuration) {
        boolean canBeResolved = ConfigurationDetails.canBeResolved(configuration);
        return new ConfigurationDetails(configuration.getName(), configuration.getDescription(), canBeResolved, (Provider<ResolvedComponentResult>)(canBeResolved ? configuration.getIncoming().getResolutionResult().getRootComponent() : null), canBeResolved ? null : UnresolvableConfigurationResult.of(configuration));
    }

    private static boolean canBeResolved(Configuration configuration) {
        boolean isDeprecatedForResolving = ((DeprecatableConfiguration)configuration).isDeprecatedForResolution();
        return configuration.isCanBeResolved() && !isDeprecatedForResolving;
    }

    private ConfigurationDetails(String name, @Nullable String description, boolean canBeResolved, @Nullable Provider<ResolvedComponentResult> resolutionResultRoot, @Nullable UnresolvableConfigurationResult unresolvableResult) {
        this.name = name;
        this.description = description;
        this.canBeResolved = canBeResolved;
        this.resolutionResultRoot = resolutionResultRoot;
        this.unresolvableResult = unresolvableResult;
    }

    public String getName() {
        return this.name;
    }

    public @Nullable String getDescription() {
        return this.description;
    }

    public boolean isCanBeResolved() {
        return this.canBeResolved;
    }

    public @Nullable Provider<ResolvedComponentResult> getResolutionResultRoot() {
        return this.resolutionResultRoot;
    }

    public @Nullable UnresolvableConfigurationResult getUnresolvableResult() {
        return this.unresolvableResult;
    }
}

