/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.objects.checker;

import java.beans.PropertyChangeSupport;
import java.beans.VetoableChangeSupport;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.security.Permission;
import java.security.Permissions;
import java.util.BitSet;
import java.util.Date;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import javax.security.auth.Subject;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.core.util.objects.checker.IObjectChecker;
import org.apache.wicket.util.lang.Classes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckingObjectOutputStream
extends ObjectOutputStream {
    private static final Logger log = LoggerFactory.getLogger(CheckingObjectOutputStream.class);
    private static final NoopOutputStream DUMMY_OUTPUT_STREAM = new NoopOutputStream();
    private static boolean available = true;
    private static Method LOOKUP_METHOD;
    private static Method GET_CLASS_DATA_LAYOUT_METHOD;
    private static Method GET_NUM_OBJ_FIELDS_METHOD;
    private static Method GET_OBJ_FIELD_VALUES_METHOD;
    private static Method GET_FIELD_METHOD;
    private static Method HAS_WRITE_REPLACE_METHOD_METHOD;
    private static Method INVOKE_WRITE_REPLACE_METHOD;
    private final IObjectChecker[] checkers;
    private final ObjectOutputStream out;
    private final LinkedList<TraceSlot> traceStack = new LinkedList();
    private final Map<Object, Object> checked = new IdentityHashMap<Object, Object>();
    private final LinkedList<CharSequence> nameStack = new LinkedList();
    private Object root;
    private final Set<Class<?>> writeObjectMethodMissing = new HashSet();
    private CharSequence simpleName = "";
    private String fieldDescription;

    public static boolean isAvailable() {
        return available;
    }

    public CheckingObjectOutputStream(OutputStream outputStream, IObjectChecker ... checkers) throws IOException, SecurityException {
        this.out = new ObjectOutputStream(outputStream);
        this.checkers = checkers;
    }

    private void check(Object obj) {
        if (obj == null) {
            return;
        }
        if (this.checked.containsKey(obj)) {
            return;
        }
        this.internalCheck(obj);
    }

    private void internalCheck(Object obj) {
        ObjectStreamClass desc;
        final Object original = obj;
        Class<?> cls = obj.getClass();
        this.nameStack.add(this.simpleName);
        this.traceStack.add(new TraceSlot(obj, this.fieldDescription));
        for (IObjectChecker checker : this.checkers) {
            IObjectChecker.Result result = checker.check(obj);
            if (result.status != IObjectChecker.Result.Status.FAILURE) continue;
            String prettyPrintMessage = this.toPrettyPrintedStack(Classes.name(cls));
            String exceptionMessage = result.reason + "\n" + prettyPrintMessage;
            throw new ObjectCheckException(exceptionMessage, result.cause);
        }
        try {
            Class<?> repCl;
            while (((Boolean)HAS_WRITE_REPLACE_METHOD_METHOD.invoke((Object)(desc = (ObjectStreamClass)LOOKUP_METHOD.invoke(null, cls, Boolean.TRUE)), (Object[])null)).booleanValue() && (obj = INVOKE_WRITE_REPLACE_METHOD.invoke((Object)desc, obj)) != null && (repCl = obj.getClass()) != cls) {
                cls = repCl;
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        if (!cls.isPrimitive()) {
            if (cls.isArray()) {
                this.checked.put(original, null);
                Class<?> ccl = cls.getComponentType();
                if (!ccl.isPrimitive()) {
                    Object[] objs = (Object[])obj;
                    for (int i = 0; i < objs.length; ++i) {
                        if (this.isKnownToBeSerializable(objs[i])) continue;
                        StringBuilder arrayPos = new StringBuilder(4).append('[').append(i).append(']');
                        this.simpleName = arrayPos;
                        this.fieldDescription = this.fieldDescription + arrayPos;
                        this.check(objs[i]);
                    }
                }
            } else if (obj instanceof Externalizable && !Proxy.isProxyClass(cls)) {
                Externalizable extObj = (Externalizable)obj;
                try {
                    extObj.writeExternal(new ObjectOutputAdaptor(){
                        private int count = 0;

                        @Override
                        public void writeObject(Object streamObj) throws IOException {
                            if (CheckingObjectOutputStream.this.checked.containsKey(streamObj)) {
                                return;
                            }
                            StringBuilder arrayPos = new StringBuilder(10).append("[write:").append(this.count++).append(']');
                            CheckingObjectOutputStream.this.simpleName = arrayPos;
                            CheckingObjectOutputStream.this.fieldDescription = CheckingObjectOutputStream.this.fieldDescription + arrayPos;
                            CheckingObjectOutputStream.this.check(streamObj);
                            CheckingObjectOutputStream.this.checked.put(streamObj, null);
                        }
                    });
                }
                catch (Exception e) {
                    if (e instanceof ObjectCheckException) {
                        throw (ObjectCheckException)e;
                    }
                    log.warn("Error delegating to Externalizable. Path: {}", (Object)this.currentPath(), (Object)e);
                }
            } else {
                Method writeObjectMethod = null;
                if (!this.writeObjectMethodMissing.contains(cls)) {
                    try {
                        writeObjectMethod = cls.getDeclaredMethod("writeObject", ObjectOutputStream.class);
                    }
                    catch (NoSuchMethodException | SecurityException e) {
                        this.writeObjectMethodMissing.add(cls);
                    }
                }
                if (writeObjectMethod != null) {
                    try {
                        class InterceptingObjectOutputStream
                        extends ObjectOutputStream {
                            private int counter;

                            InterceptingObjectOutputStream() throws IOException {
                                super(DUMMY_OUTPUT_STREAM);
                                this.enableReplaceObject(true);
                            }

                            @Override
                            protected Object replaceObject(Object streamObj) throws IOException {
                                if (streamObj == original) {
                                    return streamObj;
                                }
                                ++this.counter;
                                if (CheckingObjectOutputStream.this.checked.containsKey(streamObj)) {
                                    return null;
                                }
                                StringBuilder arrayPos = new StringBuilder(10).append("[write:").append(this.counter).append(']');
                                CheckingObjectOutputStream.this.simpleName = arrayPos;
                                CheckingObjectOutputStream.this.fieldDescription = CheckingObjectOutputStream.this.fieldDescription + arrayPos;
                                CheckingObjectOutputStream.this.check(streamObj);
                                CheckingObjectOutputStream.this.checked.put(streamObj, null);
                                return streamObj;
                            }
                        }
                        InterceptingObjectOutputStream ioos = new InterceptingObjectOutputStream();
                        ioos.writeObject(obj);
                    }
                    catch (Exception e) {
                        if (e instanceof ObjectCheckException) {
                            throw (ObjectCheckException)e;
                        }
                        log.warn("error delegating to writeObject : {}, path: {}", (Object)e.getMessage(), (Object)this.currentPath());
                    }
                } else {
                    Object[] slots;
                    try {
                        slots = (Object[])GET_CLASS_DATA_LAYOUT_METHOD.invoke((Object)desc, (Object[])null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    for (Object slot : slots) {
                        ObjectStreamClass slotDesc;
                        try {
                            Field descField = slot.getClass().getDeclaredField("desc");
                            descField.setAccessible(true);
                            slotDesc = (ObjectStreamClass)descField.get(slot);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        this.checked.put(original, null);
                        this.checkFields(obj, slotDesc);
                    }
                }
            }
        }
        this.traceStack.removeLast();
        this.nameStack.removeLast();
    }

    private void checkFields(Object obj, ObjectStreamClass desc) {
        int numFields;
        try {
            numFields = (Integer)GET_NUM_OBJ_FIELDS_METHOD.invoke((Object)desc, (Object[])null);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        if (numFields > 0) {
            ObjectStreamField[] fields = desc.getFields();
            Object[] objVals = new Object[numFields];
            int numPrimFields = fields.length - objVals.length;
            try {
                GET_OBJ_FIELD_VALUES_METHOD.invoke((Object)desc, obj, objVals);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            for (int i = 0; i < objVals.length; ++i) {
                Field field;
                if (this.isKnownToBeSerializable(objVals[i]) || this.checked.containsKey(objVals[i])) continue;
                ObjectStreamField fieldDesc = fields[numPrimFields + i];
                try {
                    field = (Field)GET_FIELD_METHOD.invoke((Object)fieldDesc, (Object[])null);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                this.simpleName = field.getName();
                this.fieldDescription = field.toString();
                this.check(objVals[i]);
            }
        }
    }

    private boolean isKnownToBeSerializable(Object obj) {
        return this.isCommonClass(obj) || this.hasCustomSerialization(obj);
    }

    private boolean isCommonClass(Object obj) {
        return obj instanceof String || obj instanceof Number || obj instanceof Date || obj instanceof Boolean || obj instanceof Class || obj instanceof Throwable;
    }

    private boolean hasCustomSerialization(Object obj) {
        return obj instanceof PropertyChangeSupport || obj instanceof VetoableChangeSupport || obj instanceof Permission || obj instanceof Permissions || obj instanceof BitSet || obj instanceof ConcurrentHashMap || obj instanceof Vector || obj instanceof InetAddress || obj instanceof SocketAddress || obj instanceof Locale || obj instanceof Random || obj instanceof ThreadLocalRandom || obj instanceof StringBuffer || obj instanceof Subject;
    }

    private StringBuilder currentPath() {
        StringBuilder b = new StringBuilder();
        Iterator it = this.nameStack.iterator();
        while (it.hasNext()) {
            b.append((CharSequence)it.next());
            if (!it.hasNext()) continue;
            b.append('/');
        }
        return b;
    }

    protected final String toPrettyPrintedStack(String type) {
        StringBuilder result = new StringBuilder(512);
        StringBuilder spaces = new StringBuilder(32);
        result.append("A problem occurred while checking object with type: ");
        result.append(type);
        result.append("\nField hierarchy is:");
        for (TraceSlot slot : this.traceStack) {
            spaces.append(' ').append(' ');
            result.append('\n').append((CharSequence)spaces).append(slot.fieldDescription);
            result.append(" [class=").append(Classes.name(slot.object.getClass()));
            if (slot.object instanceof Component) {
                Component component = (Component)slot.object;
                result.append(", path=").append(component.getPath());
            }
            result.append(']');
        }
        result.append(" <----- field that is causing the problem");
        return result.toString();
    }

    @Override
    protected final void writeObjectOverride(Object obj) throws IOException {
        if (!available) {
            return;
        }
        this.root = obj;
        if (this.fieldDescription == null) {
            this.fieldDescription = this.root instanceof Component ? ((Component)this.root).getPath() : "";
        }
        this.check(this.root);
        this.out.writeObject(obj);
    }

    @Override
    public void reset() throws IOException {
        this.root = null;
        this.checked.clear();
        this.fieldDescription = null;
        this.simpleName = null;
        this.traceStack.clear();
        this.nameStack.clear();
        this.writeObjectMethodMissing.clear();
    }

    @Override
    public void close() throws IOException {
        this.reset();
    }

    static {
        try {
            LOOKUP_METHOD = ObjectStreamClass.class.getDeclaredMethod("lookup", Class.class, Boolean.TYPE);
            LOOKUP_METHOD.setAccessible(true);
            GET_CLASS_DATA_LAYOUT_METHOD = ObjectStreamClass.class.getDeclaredMethod("getClassDataLayout", null);
            GET_CLASS_DATA_LAYOUT_METHOD.setAccessible(true);
            GET_NUM_OBJ_FIELDS_METHOD = ObjectStreamClass.class.getDeclaredMethod("getNumObjFields", null);
            GET_NUM_OBJ_FIELDS_METHOD.setAccessible(true);
            GET_OBJ_FIELD_VALUES_METHOD = ObjectStreamClass.class.getDeclaredMethod("getObjFieldValues", Object.class, Object[].class);
            GET_OBJ_FIELD_VALUES_METHOD.setAccessible(true);
            GET_FIELD_METHOD = ObjectStreamField.class.getDeclaredMethod("getField", null);
            GET_FIELD_METHOD.setAccessible(true);
            HAS_WRITE_REPLACE_METHOD_METHOD = ObjectStreamClass.class.getDeclaredMethod("hasWriteReplaceMethod", null);
            HAS_WRITE_REPLACE_METHOD_METHOD.setAccessible(true);
            INVOKE_WRITE_REPLACE_METHOD = ObjectStreamClass.class.getDeclaredMethod("invokeWriteReplace", Object.class);
            INVOKE_WRITE_REPLACE_METHOD.setAccessible(true);
        }
        catch (Exception e) {
            log.warn("SerializableChecker not available", e);
            available = false;
        }
    }

    private static final class TraceSlot {
        private final String fieldDescription;
        private final Object object;

        TraceSlot(Object object, String fieldDescription) {
            this.object = object;
            this.fieldDescription = fieldDescription;
        }

        public String toString() {
            return this.object.getClass() + " - " + this.fieldDescription;
        }
    }

    private static abstract class ObjectOutputAdaptor
    implements ObjectOutput {
        private ObjectOutputAdaptor() {
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(byte[] b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }

        @Override
        public void write(int b) throws IOException {
        }

        @Override
        public void writeBoolean(boolean v) throws IOException {
        }

        @Override
        public void writeByte(int v) throws IOException {
        }

        @Override
        public void writeBytes(String s) throws IOException {
        }

        @Override
        public void writeChar(int v) throws IOException {
        }

        @Override
        public void writeChars(String s) throws IOException {
        }

        @Override
        public void writeDouble(double v) throws IOException {
        }

        @Override
        public void writeFloat(float v) throws IOException {
        }

        @Override
        public void writeInt(int v) throws IOException {
        }

        @Override
        public void writeLong(long v) throws IOException {
        }

        @Override
        public void writeShort(int v) throws IOException {
        }

        @Override
        public void writeUTF(String str) throws IOException {
        }
    }

    private static class NoopOutputStream
    extends OutputStream {
        private NoopOutputStream() {
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(byte[] b) {
        }

        @Override
        public void write(byte[] b, int i, int l) {
        }

        @Override
        public void write(int b) {
        }
    }

    public static class ObjectCheckException
    extends WicketRuntimeException {
        public ObjectCheckException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

