/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.features.paging;

import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.eclipse.persistence.jpa.rs.exceptions.JPARSException;
import org.eclipse.persistence.jpa.rs.resources.common.AbstractResource;

abstract class AbstractPagingValidator {
    private int offset;
    private int limit;
    final Map<String, Object> queryParameters;

    AbstractPagingValidator(UriInfo uri) {
        this.queryParameters = AbstractResource.getQueryParameters(uri);
    }

    abstract boolean isFeatureApplicable() throws JPARSException;

    void checkParameters(int defaultLimit) {
        String paramLimit = (String)this.queryParameters.get("limit");
        String paramOffset = (String)this.queryParameters.get("offset");
        try {
            if (paramLimit != null) {
                int intLimit = Integer.parseInt(paramLimit);
                if (intLimit <= 0) {
                    throw JPARSException.invalidParameter("limit", paramLimit);
                }
                this.limit = intLimit > defaultLimit ? defaultLimit : intLimit;
            } else {
                this.limit = defaultLimit;
            }
        }
        catch (NumberFormatException ex) {
            throw JPARSException.invalidParameter("limit", paramLimit);
        }
        try {
            if (paramOffset != null) {
                this.offset = Integer.parseInt(paramOffset);
            }
            if (this.offset < 0) {
                throw JPARSException.invalidParameter("offset", paramOffset);
            }
        }
        catch (NumberFormatException ex) {
            throw JPARSException.invalidParameter("offset", paramOffset);
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLimit() {
        return this.limit;
    }
}

