/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.util;

import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.MemoryComputeKey;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Barrier;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.AbstractStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.ProjectedTraverser;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.TraverserSet;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public abstract class CollectingBarrierStep<S>
extends AbstractStep<S, S>
implements Barrier<TraverserSet<S>> {
    protected TraverserSet<S> traverserSet = this.traversal.getTraverserSetSupplier().get();
    private int maxBarrierSize;
    private boolean barrierConsumed = false;

    public CollectingBarrierStep(Traversal.Admin traversal) {
        this(traversal, Integer.MAX_VALUE);
    }

    public CollectingBarrierStep(Traversal.Admin traversal, int maxBarrierSize) {
        super(traversal);
        this.maxBarrierSize = maxBarrierSize;
    }

    public abstract void barrierConsumer(TraverserSet<S> var1);

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.BULK);
    }

    @Override
    public void processAllStarts() {
        if (this.starts.hasNext()) {
            if (Integer.MAX_VALUE == this.maxBarrierSize) {
                this.starts.forEachRemaining(this.traverserSet::add);
            } else {
                while (this.starts.hasNext() && this.traverserSet.size() < this.maxBarrierSize) {
                    this.traverserSet.add((Traverser.Admin<S>)this.starts.next());
                }
            }
        }
    }

    @Override
    public boolean hasNextBarrier() {
        this.processAllStarts();
        return !this.traverserSet.isEmpty();
    }

    @Override
    public TraverserSet<S> nextBarrier() throws NoSuchElementException {
        this.processAllStarts();
        if (this.traverserSet.isEmpty()) {
            throw FastNoSuchElementException.instance();
        }
        TraverserSet temp = this.traversal.getTraverserSetSupplier().get();
        IteratorUtils.removeOnNext(this.traverserSet.iterator()).forEachRemaining(t -> {
            DetachedFactory.detach(t, true);
            temp.add(t);
        });
        return temp;
    }

    @Override
    public void addBarrier(TraverserSet<S> barrier) {
        barrier.forEach(traverser -> traverser.setSideEffects(this.getTraversal().getSideEffects()));
        this.traverserSet.addAll(barrier);
        this.barrierConsumed = false;
    }

    @Override
    public Traverser.Admin<S> processNextStart() {
        if (this.traverserSet.isEmpty() && this.starts.hasNext()) {
            this.processAllStarts();
            this.barrierConsumed = false;
        }
        if (!this.barrierConsumed) {
            this.barrierConsumer(this.traverserSet);
            this.barrierConsumed = true;
        }
        return ProjectedTraverser.tryUnwrap(this.traverserSet.remove());
    }

    @Override
    public CollectingBarrierStep<S> clone() {
        CollectingBarrierStep clone = (CollectingBarrierStep)super.clone();
        clone.traverserSet = this.traversal.getTraverserSetSupplier().get();
        clone.barrierConsumed = false;
        return clone;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.maxBarrierSize == Integer.MAX_VALUE ? null : Integer.valueOf(this.maxBarrierSize));
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.maxBarrierSize;
    }

    @Override
    public void reset() {
        super.reset();
        this.traverserSet.clear();
    }

    @Override
    public MemoryComputeKey<TraverserSet<S>> getMemoryComputeKey() {
        return MemoryComputeKey.of(this.getId(), Operator.addAll, false, true);
    }
}

