/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.injectors;

import java.lang.reflect.AnnotatedElement;
import javax.servlet.ServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.impl.injectors.RequestAttributeInjector;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class RequestAttributeInjectorTest {
    private RequestAttributeInjector injector = new RequestAttributeInjector();
    @Mock
    private ServletRequest request;
    @Mock
    private AnnotatedElement element;
    @Mock
    private DisposalCallbackRegistry registry;
    private static final String STRING_PARAM = "param1";
    private static final String INTEGER_PARAM = "param2";
    private static final String CLASS_PARAM = "param3";
    private static final String STRING_VALUE = "myValue";
    private static final int INTEGER_VALUE = 42;
    private static final ResourceResolver CLASS_INSTANCE = (ResourceResolver)Mockito.mock(ResourceResolver.class);

    RequestAttributeInjectorTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.lenient().when(this.request.getAttribute(STRING_PARAM)).thenReturn((Object)STRING_VALUE);
        Mockito.lenient().when(this.request.getAttribute(INTEGER_PARAM)).thenReturn((Object)42);
        Mockito.lenient().when(this.request.getAttribute(CLASS_PARAM)).thenReturn((Object)CLASS_INSTANCE);
    }

    @Test
    void testStringParam() {
        Object result = this.injector.getValue((Object)this.request, STRING_PARAM, String.class, this.element, this.registry);
        Assertions.assertEquals((Object)STRING_VALUE, (Object)result);
    }

    @Test
    void testIntegerParam() {
        Object result = this.injector.getValue((Object)this.request, INTEGER_PARAM, Integer.class, this.element, this.registry);
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    void testClassInstance() {
        Object result = this.injector.getValue((Object)this.request, CLASS_PARAM, ResourceResolver.class, this.element, this.registry);
        Assertions.assertSame((Object)CLASS_INSTANCE, (Object)result);
    }

    @Test
    void testNonRequestAdaptable() {
        Object result = this.injector.getValue(Mockito.mock(ResourceResolver.class), STRING_PARAM, String.class, this.element, this.registry);
        Assertions.assertNull((Object)result);
    }
}

