/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.peaberry.internal;

import com.google.inject.Injector;
import com.google.inject.Key;
import java.util.Map;
import org.ops4j.peaberry.AttributeFilter;
import org.ops4j.peaberry.Export;
import org.ops4j.peaberry.Import;
import org.ops4j.peaberry.ServiceRegistry;
import org.ops4j.peaberry.ServiceWatcher;
import org.ops4j.peaberry.builders.ImportDecorator;
import org.ops4j.peaberry.internal.ConcurrentServiceWatcher;
import org.ops4j.peaberry.internal.DecoratedServiceWatcher;
import org.ops4j.peaberry.internal.Setting;
import org.ops4j.peaberry.util.Filters;
import org.ops4j.peaberry.util.StaticImport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ServiceSettings<T>
implements Cloneable {
    private final Setting<T> service;
    private final Class<T> clazz;
    private Setting<ServiceRegistry> registry = Setting.newSetting(Key.get(ServiceRegistry.class));
    private Setting<ImportDecorator<? super T>> decorator = Setting.nullSetting();
    private Setting<ServiceWatcher<? super T>> watcher = Setting.nullSetting();
    private Setting<Map<String, ?>> attributes = Setting.nullSetting();
    private Setting<AttributeFilter> filter = Setting.nullSetting();
    private Export<T> export;

    ServiceSettings(Key<? extends T> key) {
        this.service = Setting.newSetting(key);
        this.clazz = key.getTypeLiteral().getRawType();
    }

    ServiceSettings(T instance) {
        if (null == instance) {
            this.service = Setting.nullSetting();
            this.clazz = Object.class;
        } else {
            this.service = Setting.newSetting(instance);
            this.clazz = instance.getClass();
        }
    }

    void setDecorator(Setting<ImportDecorator<? super T>> decorator) {
        this.decorator = decorator;
    }

    void setAttributes(Setting<Map<String, ?>> attributes) {
        this.attributes = attributes;
    }

    void setFilter(Setting<AttributeFilter> filter) {
        this.filter = filter;
    }

    void setWatcher(Setting<ServiceWatcher<? super T>> watcher) {
        this.watcher = watcher;
    }

    void setRegistry(Setting<ServiceRegistry> registry) {
        this.registry = registry;
    }

    public ServiceSettings<T> clone() {
        try {
            return (ServiceSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return this;
        }
    }

    Class<T> getClazz() {
        return this.clazz;
    }

    ImportDecorator<? super T> getDecorator(Injector injector) {
        return this.decorator.get(injector);
    }

    private AttributeFilter getFilter(Injector injector) {
        Map<String, ?> sampleAttributes;
        AttributeFilter attributeFilter = this.filter.get(injector);
        if (null == attributeFilter && null != (sampleAttributes = this.attributes.get(injector)) && !sampleAttributes.isEmpty()) {
            this.filter = Setting.newSetting(Filters.attributes(sampleAttributes));
            return this.filter.get(injector);
        }
        return attributeFilter;
    }

    Iterable<Import<T>> getImports(Injector injector, boolean isConcurrent) {
        ServiceRegistry serviceRegistry = this.registry.get(injector);
        AttributeFilter attributeFilter = this.getFilter(injector);
        Iterable imports = serviceRegistry.lookup(this.clazz, attributeFilter);
        ServiceWatcher<? super T> serviceWatcher = this.watcher.get(injector);
        if (null != serviceWatcher && serviceRegistry != serviceWatcher) {
            ImportDecorator<? super T> watcherDecorator = this.decorator.get(injector);
            if (null != watcherDecorator) {
                serviceWatcher = new DecoratedServiceWatcher<T>(watcherDecorator, serviceWatcher);
            }
            if (isConcurrent) {
                serviceWatcher = new ConcurrentServiceWatcher<T>(imports, serviceWatcher);
            }
            serviceRegistry.watch(this.clazz, attributeFilter, serviceWatcher);
        }
        return imports;
    }

    Export<T> getExport(Injector injector) {
        T instance = this.service.get(injector);
        if (null == this.export) {
            ImportDecorator<? super T> watcherDecorator;
            DecoratedServiceWatcher<T> serviceWatcher = this.watcher.get(injector);
            if (null == serviceWatcher) {
                serviceWatcher = (DecoratedServiceWatcher<T>)((Object)this.registry.get(injector));
            }
            if (null != (watcherDecorator = this.decorator.get(injector))) {
                serviceWatcher = new DecoratedServiceWatcher<T>(watcherDecorator, serviceWatcher);
            }
            this.export = serviceWatcher.add(new StaticImport<T>(instance, this.attributes.get(injector)));
        }
        return this.export;
    }
}

