/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons.providers;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.sling.discovery.ClusterView;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.commons.providers.DefaultInstanceDescription;

public class DefaultClusterView
implements ClusterView {
    private final String id;
    private final List<InstanceDescription> instances = new LinkedList<InstanceDescription>();

    public DefaultClusterView(String id) {
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException("id must not be null");
        }
        this.id = id;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DefaultClusterView)) {
            return false;
        }
        DefaultClusterView other = (DefaultClusterView)obj;
        if (!this.id.equals(other.id)) {
            return false;
        }
        if (!this.getLeader().equals((Object)other.getLeader())) {
            return false;
        }
        if (this.instances.size() != other.instances.size()) {
            return false;
        }
        for (InstanceDescription instance : this.instances) {
            if (other.instances.contains(instance)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.instances.size() == 0) {
            return "a ClusterView[no instances]";
        }
        if (this.instances.size() == 1) {
            return "a ClusterView[1 instance: " + this.instances.get(0).getSlingId() + "]";
        }
        StringBuffer sb = new StringBuffer();
        for (InstanceDescription id : this.instances) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(id.getSlingId());
        }
        return "a ClusterView[" + this.instances.size() + " instances: " + sb.toString() + "]";
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String getId() {
        return this.id;
    }

    public void addInstanceDescription(DefaultInstanceDescription instance) {
        if (this.instances.contains(instance)) {
            throw new IllegalArgumentException("cannot add same instance twice");
        }
        if (instance.isLeader() && this.doGetLeader() != null) {
            throw new IllegalArgumentException("cannot add another leader. there already is one");
        }
        this.instances.add(instance);
        instance.setClusterView(this);
    }

    public List<InstanceDescription> getInstances() {
        if (this.instances.size() == 0) {
            throw new IllegalStateException("no instance was ever added");
        }
        return Collections.unmodifiableList(this.instances);
    }

    public InstanceDescription getLeader() {
        InstanceDescription result = this.doGetLeader();
        if (result != null) {
            return result;
        }
        throw new IllegalStateException("no leader was added");
    }

    private InstanceDescription doGetLeader() {
        for (InstanceDescription anInstance : this.instances) {
            if (!anInstance.isLeader()) continue;
            return anInstance;
        }
        return null;
    }

    public boolean removeInstanceDescription(InstanceDescription instance) {
        return this.instances.remove(instance);
    }

    public InstanceDescription getLocalInstance() {
        InstanceDescription local = null;
        for (InstanceDescription instance : this.getInstances()) {
            if (!instance.isLocal()) continue;
            if (local != null) {
                throw new IllegalStateException("found multiple local instances!?");
            }
            local = instance;
            break;
        }
        return local;
    }
}

