/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter.math;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoublePredicate;
import java.util.function.DoubleUnaryOperator;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.filter.base.Node;
import org.apache.sis.filter.visitor.FunctionIdentifier;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.pending.geoapi.filter.AvailableFunction;
import org.apache.sis.util.internal.shared.ViewAsSet;
import org.apache.sis.util.iso.Names;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.util.LocalName;
import org.opengis.util.ScopedName;
import org.opengis.util.TypeName;

public enum Function implements FunctionIdentifier,
AvailableFunction
{
    ABS(Math::abs),
    SIGN(Math::signum),
    ROUND(Math::rint),
    FLOOR(Math::floor),
    CEIL(Math::ceil),
    LOG10(Math::log10),
    LOG(Math::log),
    EXP(Math::exp),
    POWER(null, null, Math::pow),
    SQRT(Math::sqrt),
    CBRT(Math::cbrt),
    HYPOT(null, null, Math::hypot),
    ASIN(Math::asin),
    ACOS(Math::acos),
    ATAN(Math::atan),
    ATAN2(null, null, Math::atan2),
    SINH(Math::sinh),
    COSH(Math::cosh),
    TANH(Math::tanh),
    IS_FINITE(Double::isFinite, null, null),
    IS_INFINITE(Double::isInfinite, null, null),
    IS_NAN(Double::isNaN, null, null);

    private static final Map<String, Function> ALIASES;
    final DoublePredicate filter;
    final DoubleUnaryOperator unary;
    final DoubleBinaryOperator binary;
    private ScopedName name;
    private DefaultAttributeType<?> resultType;
    private static final TypeName RESULT_TYPE;
    private static final DefaultParameterDescriptor<Number> X;
    private static final DefaultParameterDescriptor<Number> Y;

    private Function(DoubleUnaryOperator math) {
        this.filter = null;
        this.unary = math;
        this.binary = null;
    }

    private Function(DoublePredicate filter, DoubleUnaryOperator unary, DoubleBinaryOperator binary) {
        this.filter = filter;
        this.unary = unary;
        this.binary = binary;
    }

    final int getMinParameterCount() {
        if (this.unary != null || this.filter != null) {
            return 1;
        }
        if (this.binary != null) {
            return 2;
        }
        return 0;
    }

    final int getMaxParameterCount() {
        if (this.binary != null) {
            return 2;
        }
        if (this.unary != null || this.filter != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public LocalName getName() {
        return this.getFunctionName().tip();
    }

    final synchronized ScopedName getFunctionName() {
        if (this.name == null) {
            this.name = Node.createName(this.name());
        }
        return this.name;
    }

    final synchronized DefaultAttributeType<?> getResultType() {
        if (this.resultType == null) {
            this.resultType = this.filter == null ? Node.createType(Double.class, this.name()) : Node.createType(Boolean.class, this.name());
        }
        return this.resultType;
    }

    @Override
    public TypeName getReturnType() {
        return RESULT_TYPE;
    }

    @Override
    public List<? extends ParameterDescriptor<?>> getArguments() {
        if (this.unary != null) {
            return List.of(X);
        }
        if (this != ATAN2) {
            return List.of(X, Y);
        }
        return List.of(Y, X);
    }

    private static DefaultParameterDescriptor<Number> parameter(String name) {
        return new DefaultParameterDescriptor(Map.of("name", name), 1, 1, Number.class, null, null, null);
    }

    @Override
    public int[] getSignature() {
        int[] dataTypes = new int[this.getMaxParameterCount() + 1];
        Arrays.fill(dataTypes, 8);
        if (this.filter != null) {
            dataTypes[0] = 16;
        }
        return dataTypes;
    }

    static List<String> namesAndAliases() {
        ArrayList<String> names = new ArrayList<String>(ViewAsSet.namesOf(Function.class));
        names.addAll(ALIASES.keySet());
        return names;
    }

    public static Function of(String name) {
        Function f = ALIASES.get(name);
        if (f == null) {
            f = Function.valueOf(name);
        }
        return f;
    }

    static {
        ALIASES = Map.of("CEILING", CEIL, "LN", LOG, "isFinite", IS_FINITE, "isInfinite", IS_INFINITE, "isNaN", IS_NAN);
        RESULT_TYPE = Names.createTypeName(Double.class);
        X = Function.parameter("x");
        Y = Function.parameter("y");
    }
}

