/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.qpid.server.filter.SelectorParsingException;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.HttpManagementUtil;
import org.apache.qpid.server.management.plugin.csv.CSVFormat;
import org.apache.qpid.server.management.plugin.servlet.query.ConfiguredObjectQuery;
import org.apache.qpid.server.management.plugin.servlet.query.EvaluationException;
import org.apache.qpid.server.management.plugin.servlet.rest.AbstractServlet;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Model;
import org.apache.qpid.server.query.engine.QueryEngine;
import org.apache.qpid.server.query.engine.evaluator.EvaluationResult;
import org.apache.qpid.server.query.engine.evaluator.QueryEvaluator;
import org.apache.qpid.server.query.engine.evaluator.settings.QuerySettings;
import org.apache.qpid.server.query.engine.model.QueryRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueryServlet<X extends ConfiguredObject<?>>
extends AbstractServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryServlet.class);
    private static final CSVFormat CSV_FORMAT = new CSVFormat();
    private QueryEngine _queryEngine;

    @Override
    public void init() {
        try {
            super.init();
            ServletContext servletContext = this.getServletContext();
            Broker broker = (Broker)servletContext.getAttribute("Qpid.broker");
            HttpManagementConfiguration config = HttpManagementUtil.getManagementConfiguration(servletContext);
            int maxQueryCacheSize = (Integer)config.getContextValue(Integer.class, "qpid.port.http.query.engine.cacheSize");
            int maxQueryDepth = (Integer)config.getContextValue(Integer.class, "qpid.port.http.query.engine.maxQueryDepth");
            ZoneId zoneId = ZoneId.of((String)config.getContextValue(String.class, "qpid.port.http.query.engine.timezoneId"));
            this._queryEngine = new QueryEngine(broker);
            this._queryEngine.setMaxQueryDepth(maxQueryDepth);
            this._queryEngine.setMaxQueryCacheSize(maxQueryCacheSize);
            this._queryEngine.setZoneId(zoneId);
            this._queryEngine.initQueryCache();
        }
        catch (Exception e) {
            LOGGER.error("Error when initializing query servlet", (Throwable)e);
        }
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response, ConfiguredObject<?> managedObject) throws IOException, ServletException {
        this.performQuery(request, response, managedObject);
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response, ConfiguredObject<?> managedObject) throws IOException {
        try {
            String content = request.getReader().lines().collect(Collectors.joining());
            if (content.isEmpty()) {
                this.performQuery(request, response, managedObject);
            } else {
                QueryRequest queryRequest = (QueryRequest)new ObjectMapper().readValue(content, QueryRequest.class);
                QuerySettings querySettings = queryRequest.toQuerySettings();
                QueryEvaluator queryEvaluator = this._queryEngine.createEvaluator();
                EvaluationResult result = queryEvaluator.execute(queryRequest.getSql(), querySettings);
                this.sendJsonResponse(result, request, response);
            }
        }
        catch (Exception e) {
            this.sendJsonErrorResponse(request, response, 500, "There was an error when performing request, see log file for details");
            LOGGER.error("Error when executing query", (Throwable)e);
        }
    }

    private void performQuery(HttpServletRequest request, HttpServletResponse response, ConfiguredObject<?> managedObject) throws IOException {
        block9: {
            String categoryName;
            X parent = this.getParent(request, managedObject);
            if (parent != null && (categoryName = this.getRequestedCategory(request, managedObject)) != null) {
                Model model = parent.getModel();
                Class<ConfiguredObject> category = this.getSupportedCategory(categoryName, model);
                if (category != null) {
                    List<ConfiguredObject<?>> objects = this.getAllObjects(parent, category, request);
                    try {
                        ConfiguredObjectQuery query = new ConfiguredObjectQuery(objects, request.getParameter("select"), request.getParameter("where"), request.getParameter("orderBy"), request.getParameter("limit"), request.getParameter("offset"));
                        String attachmentFilename = request.getParameter("contentDispositionAttachmentFilename");
                        if (attachmentFilename != null) {
                            this.setContentDispositionHeaderIfNecessary(response, attachmentFilename);
                        }
                        if ("csv".equalsIgnoreCase(request.getParameter("format"))) {
                            this.sendCsvResponse(query, response);
                            break block9;
                        }
                        LinkedHashMap<String, Object> resultsObject = new LinkedHashMap<String, Object>();
                        resultsObject.put("headers", query.getHeaders());
                        resultsObject.put("results", query.getResults());
                        resultsObject.put("total", query.getTotalNumberOfRows());
                        this.sendJsonResponse(resultsObject, request, response);
                    }
                    catch (SelectorParsingException e) {
                        this.sendJsonErrorResponse(request, response, 400, "There was an error when performing request, see log file for details");
                        LOGGER.error("Error when executing request", (Throwable)e);
                    }
                    catch (EvaluationException e) {
                        this.sendJsonErrorResponse(request, response, 422, "There was an error when performing request, see log file for details");
                        LOGGER.error("Error when executing request", (Throwable)e);
                    }
                } else {
                    this.sendJsonErrorResponse(request, response, 404, "Unknown object type " + categoryName);
                }
            } else {
                this.sendJsonErrorResponse(request, response, 404, "Invalid path");
            }
        }
    }

    private void sendCsvResponse(ConfiguredObjectQuery query, HttpServletResponse response) throws IOException {
        response.setStatus(200);
        response.setContentType("text/csv;charset=utf-8;");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        this.sendCachingHeadersOnResponse(response);
        try (PrintWriter writer = response.getWriter();){
            CSV_FORMAT.printRecord(writer, query.getHeaders());
            CSV_FORMAT.printRecords(writer, query.getResults());
        }
    }

    protected abstract X getParent(HttpServletRequest var1, ConfiguredObject<?> var2);

    protected abstract Class<? extends ConfiguredObject> getSupportedCategory(String var1, Model var2);

    protected abstract String getRequestedCategory(HttpServletRequest var1, ConfiguredObject<?> var2);

    protected abstract List<ConfiguredObject<?>> getAllObjects(X var1, Class<? extends ConfiguredObject> var2, HttpServletRequest var3);
}

