/*
 * Decompiled with CFR 0.152.
 */
package org.archive.resource.gzip;

import java.io.IOException;
import java.util.Locale;
import org.archive.format.gzip.GZIPMemberSeries;
import org.archive.format.gzip.GZIPSeriesMember;
import org.archive.resource.MetaData;
import org.archive.resource.Resource;
import org.archive.resource.ResourceContainer;
import org.archive.resource.ResourceParseException;
import org.archive.resource.ResourceProducer;
import org.archive.resource.gzip.GZIPResource;

public class GZIPResourceContainer
implements ResourceContainer,
ResourceProducer {
    private static long UNLIMITED = -1L;
    private long endOffset;
    private GZIPMemberSeries series;

    public GZIPResourceContainer(GZIPMemberSeries series) {
        this(series, UNLIMITED);
    }

    public GZIPResourceContainer(GZIPMemberSeries series, long endOffset) {
        this.series = series;
        this.endOffset = endOffset;
    }

    @Override
    public String getName() {
        return this.series.getStreamContext();
    }

    @Override
    public boolean isCompressed() {
        return true;
    }

    @Override
    public Resource getNext() throws ResourceParseException, IOException {
        if (this.series.gotEOF()) {
            return null;
        }
        if (this.endOffset != UNLIMITED && this.series.getOffset() > this.endOffset) {
            return null;
        }
        GZIPSeriesMember member = this.series.getNextMember();
        if (member == null) {
            return null;
        }
        MetaData top = new MetaData();
        return new GZIPResource(top, this, member);
    }

    @Override
    public void close() throws IOException {
        this.series.close();
    }

    @Override
    public String getContext() {
        return String.format(Locale.ROOT, "Context(%s)(%d)", this.series.getStreamContext(), this.series.getCurrentMemberStartOffset());
    }
}

