/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.engine;

import java.io.IOException;
import java.util.function.BiConsumer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.search.ReferenceManager;
import org.opensearch.common.SuppressForbidden;
import org.opensearch.common.lucene.index.OpenSearchDirectoryReader;

@SuppressForbidden(reason="reference counting is required here")
class OpenSearchReaderManager
extends ReferenceManager<OpenSearchDirectoryReader> {
    private final BiConsumer<OpenSearchDirectoryReader, OpenSearchDirectoryReader> refreshListener;

    OpenSearchReaderManager(OpenSearchDirectoryReader reader, BiConsumer<OpenSearchDirectoryReader, OpenSearchDirectoryReader> refreshListener) {
        this.current = reader;
        this.refreshListener = refreshListener;
        refreshListener.accept((OpenSearchDirectoryReader)((Object)this.current), null);
    }

    protected void decRef(OpenSearchDirectoryReader reference) throws IOException {
        reference.decRef();
    }

    protected OpenSearchDirectoryReader refreshIfNeeded(OpenSearchDirectoryReader referenceToRefresh) throws IOException {
        OpenSearchDirectoryReader reader = (OpenSearchDirectoryReader)DirectoryReader.openIfChanged((DirectoryReader)referenceToRefresh);
        if (reader != null) {
            this.refreshListener.accept(reader, referenceToRefresh);
        }
        return reader;
    }

    protected boolean tryIncRef(OpenSearchDirectoryReader reference) {
        return reference.tryIncRef();
    }

    protected int getRefCount(OpenSearchDirectoryReader reference) {
        return reference.getRefCount();
    }
}

