/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa;

import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import jakarta.persistence.PersistenceConfiguration;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.spi.PersistenceProvider;
import javax.sql.DataSource;
import org.jspecify.annotations.Nullable;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.util.Assert;

public class LocalEntityManagerFactoryBean
extends AbstractEntityManagerFactoryBean {
    private @Nullable PersistenceConfiguration configuration;

    public LocalEntityManagerFactoryBean() {
        this.setPersistenceUnitName("default");
    }

    public LocalEntityManagerFactoryBean(String persistenceUnitName) {
        this.setPersistenceUnitName(persistenceUnitName);
    }

    public LocalEntityManagerFactoryBean(PersistenceConfiguration configuration) {
        this.setPersistenceConfiguration(configuration);
    }

    public void setPersistenceConfiguration(PersistenceConfiguration configuration) {
        Assert.notNull((Object)configuration, (String)"PersistenceConfiguration must not be null");
        this.configuration = configuration;
        this.setPersistenceUnitName(configuration.name());
    }

    public PersistenceConfiguration getPersistenceConfiguration() {
        if (this.configuration == null) {
            this.configuration = new PersistenceConfiguration(this.getPersistenceUnitName());
        }
        return this.configuration;
    }

    @Override
    public void setPersistenceUnitName(@Nullable String persistenceUnitName) {
        Assert.state((this.configuration == null || this.configuration.name().equals(persistenceUnitName) ? 1 : 0) != 0, (String)"Cannot change setPersistenceUnitName when PersistenceConfiguration has been set");
        super.setPersistenceUnitName(persistenceUnitName);
    }

    public void setDataSource(@Nullable DataSource dataSource) {
        if (dataSource != null) {
            this.getJpaPropertyMap().put("jakarta.persistence.dataSource", dataSource);
        } else {
            this.getJpaPropertyMap().remove("jakarta.persistence.dataSource");
        }
    }

    @Override
    public @Nullable DataSource getDataSource() {
        return (DataSource)this.getJpaPropertyMap().get("jakarta.persistence.dataSource");
    }

    @Override
    protected EntityManagerFactory createNativeEntityManagerFactory() throws PersistenceException {
        PersistenceProvider provider;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Building JPA EntityManagerFactory for persistence unit '" + this.getPersistenceUnitName() + "'"));
        }
        if (this.configuration != null) {
            this.configuration.properties(this.getJpaPropertyMap());
        }
        if ((provider = this.getPersistenceProvider()) != null) {
            EntityManagerFactory emf;
            EntityManagerFactory entityManagerFactory = emf = this.configuration != null ? provider.createEntityManagerFactory(this.configuration) : provider.createEntityManagerFactory(this.getPersistenceUnitName(), this.getJpaPropertyMap());
            if (emf == null) {
                throw new IllegalStateException("PersistenceProvider [" + String.valueOf(provider) + "] did not return an EntityManagerFactory for name '" + this.getPersistenceUnitName() + "'");
            }
            return emf;
        }
        return this.configuration != null ? Persistence.createEntityManagerFactory((PersistenceConfiguration)this.configuration) : Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), this.getJpaPropertyMap());
    }
}

