/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.serialization;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.registry.serialization.FlowContent;
import org.apache.nifi.registry.serialization.SerializationException;
import org.apache.nifi.registry.serialization.VersionedSerializer;
import org.apache.nifi.registry.serialization.jackson.JacksonFlowContentSerializer;
import org.apache.nifi.registry.serialization.jackson.JacksonVersionedProcessGroupSerializer;
import org.apache.nifi.registry.serialization.jaxb.JAXBVersionedProcessGroupSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FlowContentSerializer {
    private static final Logger logger = LoggerFactory.getLogger(FlowContentSerializer.class);
    static final Integer START_USING_SNAPSHOT_VERSION = 3;
    static final Integer CURRENT_DATA_MODEL_VERSION = 3;
    private final Map<Integer, VersionedSerializer<VersionedProcessGroup>> processGroupSerializers;
    private final Map<Integer, VersionedSerializer<FlowContent>> flowContentSerializers;
    private final Map<Integer, VersionedSerializer<?>> allSerializers;
    private final List<Integer> descendingVersions;

    public FlowContentSerializer() {
        HashMap<Integer, JacksonFlowContentSerializer> tempFlowContentSerializers = new HashMap<Integer, JacksonFlowContentSerializer>();
        tempFlowContentSerializers.put(3, new JacksonFlowContentSerializer());
        this.flowContentSerializers = Collections.unmodifiableMap(tempFlowContentSerializers);
        HashMap<Integer, VersionedSerializer<VersionedProcessGroup>> tempProcessGroupSerializers = new HashMap<Integer, VersionedSerializer<VersionedProcessGroup>>();
        tempProcessGroupSerializers.put(2, new JacksonVersionedProcessGroupSerializer());
        tempProcessGroupSerializers.put(1, new JAXBVersionedProcessGroupSerializer());
        this.processGroupSerializers = Collections.unmodifiableMap(tempProcessGroupSerializers);
        HashMap<Integer, VersionedSerializer<Object>> tempAllSerializers = new HashMap<Integer, VersionedSerializer<Object>>();
        tempAllSerializers.putAll(this.processGroupSerializers);
        tempAllSerializers.putAll(this.flowContentSerializers);
        this.allSerializers = Collections.unmodifiableMap(tempAllSerializers);
        ArrayList<Integer> sortedVersions = new ArrayList<Integer>(this.allSerializers.keySet());
        sortedVersions.sort(Collections.reverseOrder(Integer::compareTo));
        this.descendingVersions = sortedVersions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readDataModelVersion(InputStream input) throws SerializationException {
        InputStream markSupportedInput = input.markSupported() ? input : new BufferedInputStream(input);
        markSupportedInput.mark(1024);
        for (int serializerVersion : this.descendingVersions) {
            VersionedSerializer<?> serializer = this.allSerializers.get(serializerVersion);
            try {
                int n = serializer.readDataModelVersion(markSupportedInput);
                return n;
            }
            catch (SerializationException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.error("Unable to read the data model version due to: {}", (Object)e.getMessage());
            }
            finally {
                try {
                    markSupportedInput.reset();
                }
                catch (IOException resetException) {
                    logger.error("Unable to reset the input stream.", (Throwable)resetException);
                }
            }
        }
        throw new SerializationException("Unable to read the data model version for the flow content.");
    }

    public Integer getCurrentDataModelVersion() {
        return CURRENT_DATA_MODEL_VERSION;
    }

    public boolean isProcessGroupVersion(int dataModelVersion) {
        return dataModelVersion < START_USING_SNAPSHOT_VERSION;
    }

    public VersionedProcessGroup deserializeProcessGroup(int dataModelVersion, InputStream input) throws SerializationException {
        VersionedSerializer<VersionedProcessGroup> serializer = this.processGroupSerializers.get(dataModelVersion);
        if (serializer == null) {
            throw new IllegalArgumentException("No VersionedProcessGroup serializer exists for data model version: " + dataModelVersion);
        }
        return serializer.deserialize(input);
    }

    public FlowContent deserializeFlowContent(int dataModelVersion, InputStream input) throws SerializationException {
        VersionedSerializer<FlowContent> serializer = this.flowContentSerializers.get(dataModelVersion);
        if (serializer == null) {
            throw new IllegalArgumentException("No FlowContent serializer exists for data model version: " + dataModelVersion);
        }
        return serializer.deserialize(input);
    }

    public void serializeFlowContent(FlowContent flowContent, OutputStream out) throws SerializationException {
        VersionedSerializer<FlowContent> serializer = this.flowContentSerializers.get(CURRENT_DATA_MODEL_VERSION);
        serializer.serialize(CURRENT_DATA_MODEL_VERSION, flowContent, out);
    }
}

