/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.authentication;

import jakarta.servlet.http.HttpServletRequest;
import org.apache.nifi.registry.security.authentication.AuthenticationRequest;
import org.apache.nifi.registry.security.authentication.IdentityProvider;
import org.apache.nifi.registry.security.authentication.IdentityProviderUsage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BearerAuthIdentityProvider
implements IdentityProvider {
    public static final String AUTHORIZATION = "Authorization";
    public static final String BEARER = "Bearer ";
    private static final Logger logger = LoggerFactory.getLogger(BearerAuthIdentityProvider.class);
    private static final IdentityProviderUsage usage = new IdentityProviderUsage(){

        @Override
        public String getText() {
            return "The user credentials must be passed in standard HTTP Bearer Authorization format. That is: 'Authorization: Bearer <token>', where <token> is a value that will be validated by this identity provider.";
        }

        @Override
        public IdentityProviderUsage.AuthType getAuthType() {
            return IdentityProviderUsage.AuthType.BEARER;
        }
    };

    @Override
    public IdentityProviderUsage getUsageInstructions() {
        return usage;
    }

    @Override
    public AuthenticationRequest extractCredentials(HttpServletRequest request) {
        if (request == null) {
            logger.debug("Cannot extract user credentials from null servletRequest");
            return null;
        }
        if (!request.isSecure()) {
            return null;
        }
        String authorization = request.getHeader(AUTHORIZATION);
        if (authorization == null || !authorization.startsWith(BEARER)) {
            logger.debug("HTTP Bearer Auth credentials not present. Not attempting to extract credentials for authentication.");
            return null;
        }
        String token = authorization.substring(BEARER.length()).trim();
        return new AuthenticationRequest(null, token, null);
    }
}

