/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.MavenException;
import org.apache.maven.api.services.ProblemCollector;

@Experimental
public abstract class MavenBuilderException
extends MavenException {
    private final ProblemCollector<BuilderProblem> problems;

    public MavenBuilderException(String message, Throwable cause) {
        super(message, cause);
        this.problems = ProblemCollector.empty();
    }

    public MavenBuilderException(String message, ProblemCollector<BuilderProblem> problems) {
        super(MavenBuilderException.buildMessage(message, problems), null);
        this.problems = problems;
    }

    protected static String buildMessage(String message, ProblemCollector<BuilderProblem> problems) {
        StringBuilder msg = new StringBuilder(message);
        problems.problems().forEach(problem -> msg.append("\n * ").append(problem.getSeverity().name()).append(": ").append(problem.getMessage()));
        return msg.toString();
    }

    public ProblemCollector<BuilderProblem> getProblemCollector() {
        return this.problems;
    }
}

