/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.store;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ByteBufferInputStream
extends InputStream {
    private static final Logger LOG = LoggerFactory.getLogger(ByteBufferInputStream.class);
    private final int size;
    private ByteBuffer byteBuffer;

    public ByteBufferInputStream(int size, ByteBuffer byteBuffer) {
        LOG.debug("Creating ByteBufferInputStream of size {}", (Object)size);
        this.size = size;
        this.byteBuffer = byteBuffer;
    }

    @Override
    public synchronized void close() {
        LOG.debug("ByteBufferInputStream.close()");
        this.byteBuffer = null;
    }

    public synchronized boolean isOpen() {
        return this.byteBuffer != null;
    }

    private void verifyOpen() throws IOException {
        if (this.byteBuffer == null) {
            throw new IOException("Stream is closed!");
        }
    }

    private void checkOpenState() {
        Preconditions.checkState(this.isOpen(), "Stream is closed!");
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.available() > 0) {
            return this.byteBuffer.get() & 0xFF;
        }
        return -1;
    }

    @Override
    public synchronized long skip(long offset) throws IOException {
        this.verifyOpen();
        long newPos = (long)this.position() + offset;
        if (newPos < 0L) {
            throw new EOFException("Cannot seek to a negative offset");
        }
        if (newPos > (long)this.size) {
            throw new EOFException("Attempted to seek or read past the end of the file");
        }
        this.byteBuffer.position((int)newPos);
        return newPos;
    }

    @Override
    public synchronized int available() {
        this.checkOpenState();
        return this.byteBuffer.remaining();
    }

    public synchronized int position() {
        this.checkOpenState();
        return this.byteBuffer.position();
    }

    public synchronized boolean hasRemaining() {
        this.checkOpenState();
        return this.byteBuffer.hasRemaining();
    }

    @Override
    public synchronized void mark(int readlimit) {
        LOG.debug("mark at {}", (Object)this.position());
        this.checkOpenState();
        this.byteBuffer.mark();
    }

    @Override
    public synchronized void reset() throws IOException {
        LOG.debug("reset");
        this.checkOpenState();
        this.byteBuffer.reset();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized int read(byte[] b, int offset, int length) throws IOException {
        Preconditions.checkArgument(length >= 0, "length is negative");
        Preconditions.checkArgument(b != null, "Null buffer");
        if (b.length - offset < length) {
            throw new IndexOutOfBoundsException("Requested more bytes than destination buffer size: request length =" + length + ", with offset =" + offset + "; buffer capacity =" + (b.length - offset));
        }
        this.verifyOpen();
        if (!this.hasRemaining()) {
            return -1;
        }
        int toRead = Math.min(length, this.available());
        this.byteBuffer.get(b, offset, toRead);
        return toRead;
    }

    public String toString() {
        return "ByteBufferInputStream{size=" + this.size + ", byteBuffer=" + this.byteBuffer + (this.byteBuffer != null ? ", available=" + this.byteBuffer.remaining() : "") + "} " + super.toString();
    }
}

