/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

public class ApiConfigEnforcement {
    @SerializedName(value="label")
    private String label = null;
    @SerializedName(value="defaultValue")
    private String defaultValue = null;
    @SerializedName(value="unit")
    private String unit = null;
    @SerializedName(value="separator")
    private String separator = null;

    public ApiConfigEnforcement label(String label) {
        this.label = label;
        return this;
    }

    @Schema(description="A label can be used to retrieve a set of configurations where this enforcement is applied. This is currently restricted to only those enums defined in ParamSpecLabel.java.  All these configurations having the same label must be uniform. In other words, all these configurations must accept the same configuration input.  There are two variations. Different configurations may have 1. different units for numeric configurations 2. different separators for list style configurations.")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public ApiConfigEnforcement defaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @Schema(description="The new default value that these configurations should use instead of what is supplied by in Cloudera Manager by default.")
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public ApiConfigEnforcement unit(String unit) {
        this.unit = unit;
        return this;
    }

    @Schema(description="This can be MILLISECONDS, SECONDS, MINUTES, HOURS, BYTES, KILOBYTES, MEGABYTES, GIGABYTES, PERCENT, PAGES, TIMES, LINES. Optional.")
    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public ApiConfigEnforcement separator(String separator) {
        this.separator = separator;
        return this;
    }

    @Schema(description="The new default value could be applied to configurations that require different separators. We need to know the separator the supplied default value has in order to generate the correct default value correctly. Optional.")
    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiConfigEnforcement apiConfigEnforcement = (ApiConfigEnforcement)o;
        return Objects.equals(this.label, apiConfigEnforcement.label) && Objects.equals(this.defaultValue, apiConfigEnforcement.defaultValue) && Objects.equals(this.unit, apiConfigEnforcement.unit) && Objects.equals(this.separator, apiConfigEnforcement.separator);
    }

    public int hashCode() {
        return Objects.hash(this.label, this.defaultValue, this.unit, this.separator);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiConfigEnforcement {\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    defaultValue: ").append(this.toIndentedString(this.defaultValue)).append("\n");
        sb.append("    unit: ").append(this.toIndentedString(this.unit)).append("\n");
        sb.append("    separator: ").append(this.toIndentedString(this.separator)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

