/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.builder.property.interpreter;

import org.apache.knox.gateway.GatewayResources;
import org.apache.knox.gateway.i18n.resources.ResourcesFactory;
import org.apache.knox.gateway.topology.Topology;
import org.apache.knox.gateway.topology.builder.property.interpreter.AbstractInterpreter;
import org.apache.knox.gateway.topology.builder.property.interpreter.InterpretException;
import org.apache.knox.gateway.topology.builder.property.interpreter.TopologyPropertyInterpreter;

public class PropertyInterpreter
extends AbstractInterpreter {
    private static final String AGGREGATOR_TOPOLOGY = "topology";
    private static GatewayResources gatewayResources = (GatewayResources)ResourcesFactory.get(GatewayResources.class);
    private final Topology topology;

    public PropertyInterpreter(Topology topology) {
        if (topology == null) {
            throw new IllegalArgumentException(gatewayResources.topologyIsRequiredError());
        }
        this.topology = topology;
    }

    @Override
    public void interpret(String token, String value) throws InterpretException {
        String nextToken;
        int firstDotPosition = token.indexOf(".");
        if (firstDotPosition != -1) {
            String aggregator = token.substring(0, firstDotPosition);
            nextToken = token.substring(firstDotPosition + 1);
            if (!AGGREGATOR_TOPOLOGY.equalsIgnoreCase(aggregator)) {
                throw new InterpretException(gatewayResources.unsupportedPropertyTokenError(token));
            }
        } else {
            throw new InterpretException(gatewayResources.unsupportedPropertyTokenError(token));
        }
        new TopologyPropertyInterpreter(this.topology).interpret(nextToken, value);
    }
}

