/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm;

import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;

public class TypeNameFilter {
    private final Collection<String> excludedTypeNames;

    public TypeNameFilter(Collection<String> excludedTypeNames) {
        this.excludedTypeNames = this.mapToLowerCase(excludedTypeNames);
    }

    public boolean isExcluded(String roleType) {
        return this.excludedTypeNames.contains(roleType.toLowerCase(Locale.ROOT));
    }

    private Set<String> mapToLowerCase(Collection<String> items) {
        if (items == null) {
            return Collections.emptySet();
        }
        return items.stream().map(item -> item.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
    }
}

