/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.management.internal;

import java.util.HashMap;
import java.util.Locale;
import org.apache.karaf.management.internal.EventAdminLogger;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class EventAdminLoggerImpl
implements EventAdminLogger {
    private final ServiceTracker<EventAdmin, EventAdmin> tracker;

    public EventAdminLoggerImpl(BundleContext context) {
        this.tracker = new ServiceTracker(context, EventAdmin.class.getName(), null);
        this.tracker.open();
    }

    @Override
    public void close() {
        this.tracker.close();
    }

    @Override
    public void log(String methodName, String[] signature, Object result, Throwable error, Object ... params) {
        EventAdmin admin = (EventAdmin)this.tracker.getService();
        if (admin != null) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("method", methodName);
            props.put("signature", signature);
            props.put("params", params);
            if (result != null) {
                props.put("result", result);
            }
            if (error != null) {
                props.put("error", error);
            }
            Event event = new Event("javax/management/MBeanServer/" + methodName.toUpperCase(Locale.ENGLISH), props);
            admin.postEvent(event);
        }
    }
}

