/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.ComplianceViolation;
import org.eclipse.jetty.http.CookieCompliance;
import org.eclipse.jetty.http.CookieParser;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieCache
extends AbstractList<HttpCookie>
implements CookieParser.Handler,
ComplianceViolation.Listener {
    protected static final Logger LOG = LoggerFactory.getLogger(CookieCache.class);
    protected final List<String> _rawFields = new ArrayList<String>();
    private final CookieParser _parser;
    private List<HttpCookie> _httpCookies = Collections.emptyList();
    private Map<Class<?>, Object[]> _apiCookies;
    private List<ComplianceViolation.Event> _violations;

    public static List<HttpCookie> getCookies(Request request) {
        List cookies = (List)request.getAttribute("org.eclipse.jetty.server.Request.Cookies");
        if (cookies != null) {
            return cookies;
        }
        CookieCache cookieCache = (CookieCache)request.getComponents().getCache().getAttribute("org.eclipse.jetty.server.Request.Cookies");
        if (cookieCache == null) {
            cookieCache = new CookieCache(request.getConnectionMetaData().getHttpConfiguration().getRequestCookieCompliance());
            request.getComponents().getCache().setAttribute("org.eclipse.jetty.server.Request.Cookies", cookieCache);
        }
        cookieCache.parseCookies(request.getHeaders(), HttpChannel.from(request).getComplianceViolationListener());
        request.setAttribute("org.eclipse.jetty.server.Request.Cookies", cookieCache);
        return cookieCache;
    }

    public static <C> C[] getApiCookies(Request request, Class<C> cookieClass, Function<HttpCookie, C> convertor) {
        if (request == null) {
            return null;
        }
        CookieCache cookieCache = (CookieCache)request.getAttribute("org.eclipse.jetty.server.Request.Cookies");
        if (cookieCache == null) {
            cookieCache = (CookieCache)request.getComponents().getCache().getAttribute("org.eclipse.jetty.server.Request.Cookies");
            if (cookieCache == null) {
                cookieCache = new CookieCache(request.getConnectionMetaData().getHttpConfiguration().getRequestCookieCompliance());
                request.getComponents().getCache().setAttribute("org.eclipse.jetty.server.Request.Cookies", cookieCache);
            }
            cookieCache.parseCookies(request.getHeaders(), HttpChannel.from(request).getComplianceViolationListener());
            request.setAttribute("org.eclipse.jetty.server.Request.Cookies", cookieCache);
        }
        return cookieCache.getApiCookies(cookieClass, convertor);
    }

    public CookieCache() {
        this(CookieCompliance.RFC6265);
    }

    public CookieCache(CookieCompliance compliance) {
        this._parser = CookieParser.newParser(this, compliance, this);
    }

    @Override
    public HttpCookie get(int index) {
        return this._httpCookies.get(index);
    }

    @Override
    public int size() {
        return this._httpCookies.size();
    }

    @Override
    public void onComplianceViolation(ComplianceViolation.Event event) {
        if (this._violations == null) {
            this._violations = new ArrayList<ComplianceViolation.Event>();
        }
        this._violations.add(event);
    }

    @Override
    public void addCookie(String cookieName, String cookieValue, int cookieVersion, String cookieDomain, String cookiePath, String cookieComment) {
        if (StringUtil.isEmpty(cookieDomain) && StringUtil.isEmpty(cookiePath) && cookieVersion <= 0 && StringUtil.isEmpty(cookieComment)) {
            this._httpCookies.add(HttpCookie.from(cookieName, cookieValue));
        } else {
            HashMap<String, String> attributes = new HashMap<String, String>();
            if (!StringUtil.isEmpty(cookieDomain)) {
                attributes.put("Domain", cookieDomain);
            }
            if (!StringUtil.isEmpty(cookiePath)) {
                attributes.put("Path", cookiePath);
            }
            if (!StringUtil.isEmpty(cookieComment)) {
                attributes.put("Comment", cookieComment);
            }
            this._httpCookies.add(HttpCookie.from(cookieName, cookieValue, cookieVersion, attributes));
        }
    }

    List<HttpCookie> getCookies(HttpFields headers) {
        this.parseCookies(headers, ComplianceViolation.Listener.NOOP);
        return this._httpCookies;
    }

    public void parseCookies(HttpFields headers, ComplianceViolation.Listener complianceViolationListener) {
        boolean building = false;
        ListIterator<String> raw = this._rawFields.listIterator();
        for (HttpField field : headers) {
            String value;
            if (!HttpHeader.COOKIE.equals((Object)field.getHeader()) || StringUtil.isBlank(value = field.getValue())) continue;
            if (building) {
                this._rawFields.add(value);
                continue;
            }
            if (!raw.hasNext()) {
                building = true;
                this._rawFields.add(value);
                continue;
            }
            if (value.equals(raw.next())) continue;
            building = true;
            raw.remove();
            while (raw.hasNext()) {
                raw.next();
                raw.remove();
            }
            this._rawFields.add(value);
        }
        if (!building && raw.hasNext()) {
            building = true;
            while (raw.hasNext()) {
                raw.next();
                raw.remove();
            }
        }
        if (building) {
            this._httpCookies = new ArrayList<HttpCookie>();
            this._apiCookies = null;
            try {
                if (this._violations != null) {
                    this._violations.clear();
                }
                this._parser.parseFields(this._rawFields);
            }
            catch (CookieParser.InvalidCookieException invalidCookieException) {
                throw new BadMessageException(invalidCookieException.getMessage(), (Throwable)invalidCookieException);
            }
        }
        if (this._violations != null && !this._violations.isEmpty()) {
            this._violations.forEach(complianceViolationListener::onComplianceViolation);
        }
    }

    public <C> C[] getApiCookies(Class<C> apiClass, Function<HttpCookie, C> convertor) {
        if (this._httpCookies.isEmpty()) {
            return null;
        }
        if (this._apiCookies == null) {
            C[] apiCookies = this.convert(apiClass, convertor);
            this._apiCookies = Map.of(apiClass, apiCookies);
            return apiCookies;
        }
        Object[] apiCookies = this._apiCookies.get(apiClass);
        if (apiCookies == null) {
            if (this._apiCookies.size() == 1) {
                this._apiCookies = new HashMap(this._apiCookies);
            }
            apiCookies = this.convert(apiClass, convertor);
            this._apiCookies.put(apiClass, apiCookies);
        }
        return apiCookies;
    }

    private <C> C[] convert(Class<C> apiClass, Function<HttpCookie, C> convertor) {
        Object[] apiCookies = (Object[])Array.newInstance(apiClass, this._httpCookies.size());
        int i = 0;
        for (HttpCookie httpCookie : this._httpCookies) {
            C apiCookie = convertor.apply(httpCookie);
            if (apiCookie == null) {
                apiCookies = Arrays.copyOf(apiCookies, apiCookies.length - 1);
                continue;
            }
            apiCookies[i++] = apiCookie;
        }
        return apiCookies;
    }
}

