/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.bkd;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.DocBaseBitSetIterator;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.LongsRef;

final class DocIdsWriter {
    private static final byte CONTINUOUS_IDS = -2;
    private static final byte BITSET_IDS = -1;
    private static final byte DELTA_BPV_16 = 16;
    private static final byte BPV_21 = 21;
    private static final byte BPV_24 = 24;
    private static final byte BPV_32 = 32;
    private static final byte LEGACY_DELTA_VINT = 0;
    private final int[] scratch;
    private final LongsRef scratchLongs = new LongsRef();
    private final IntsRef scratchIntsRef = new IntsRef();
    private final int version;

    DocIdsWriter(int maxPointsInLeaf, int version2) {
        this.scratchIntsRef.offset = 0;
        this.scratch = new int[maxPointsInLeaf];
        this.version = version2;
    }

    void writeDocIds(int[] docIds, int start, int count, DataOutput out) throws IOException {
        block26: {
            int i;
            int max2;
            block25: {
                int i2;
                boolean strictlySorted = true;
                int min2 = docIds[0];
                max2 = docIds[0];
                for (int i3 = 1; i3 < count; ++i3) {
                    int last = docIds[start + i3 - 1];
                    int current = docIds[start + i3];
                    if (last >= current) {
                        strictlySorted = false;
                    }
                    min2 = Math.min(min2, current);
                    max2 = Math.max(max2, current);
                }
                int min2max = max2 - min2 + 1;
                if (strictlySorted) {
                    if (min2max == count) {
                        out.writeByte((byte)-2);
                        out.writeVInt(docIds[start]);
                        return;
                    }
                    if (min2max <= count << 4) {
                        assert (min2max > count) : "min2max: " + min2max + ", count: " + count;
                        out.writeByte((byte)-1);
                        DocIdsWriter.writeIdsAsBitSet(docIds, start, count, out);
                        return;
                    }
                }
                if (min2max > 65535) break block25;
                out.writeByte((byte)16);
                for (i = 0; i < count; ++i) {
                    this.scratch[i] = docIds[start + i] - min2;
                }
                out.writeVInt(min2);
                int halfLen = count >> 1;
                for (i2 = 0; i2 < halfLen; ++i2) {
                    this.scratch[i2] = this.scratch[halfLen + i2] | this.scratch[i2] << 16;
                }
                for (i2 = 0; i2 < halfLen; ++i2) {
                    out.writeInt(this.scratch[i2]);
                }
                if ((count & 1) != 1) break block26;
                out.writeShort((short)this.scratch[count - 1]);
                break block26;
            }
            if (max2 <= 0x1FFFFF && this.version >= 10) {
                int i4;
                out.writeByte((byte)21);
                int oneThird = DocIdsWriter.floorToMultipleOf16(count / 3);
                numInts = oneThird * 2;
                for (i4 = 0; i4 < numInts; ++i4) {
                    this.scratch[i4] = docIds[i4 + start] << 11;
                }
                for (i4 = 0; i4 < oneThird; ++i4) {
                    int longIdx = i4 + numInts + start;
                    int n = i4;
                    this.scratch[n] = this.scratch[n] | docIds[longIdx] & 0x7FF;
                    int n2 = i4 + oneThird;
                    this.scratch[n2] = this.scratch[n2] | docIds[longIdx] >>> 11 & 0x7FF;
                }
                for (i4 = 0; i4 < numInts; ++i4) {
                    out.writeInt(this.scratch[i4]);
                }
                for (i4 = oneThird * 3; i4 < count - 2; i4 += 3) {
                    out.writeLong((long)docIds[i4] | (long)docIds[i4 + 1] << 21 | (long)docIds[i4 + 2] << 42);
                }
                while (i4 < count) {
                    out.writeShort((short)docIds[start + i4]);
                    out.writeByte((byte)(docIds[start + i4] >>> 16));
                    ++i4;
                }
            } else if (max2 <= 0xFFFFFF) {
                out.writeByte((byte)24);
                if (this.version < 10) {
                    DocIdsWriter.writeScalarInts24(docIds, start, count, out);
                } else {
                    int i5;
                    int quarter = count >> 2;
                    numInts = quarter * 3;
                    for (i5 = 0; i5 < numInts; ++i5) {
                        this.scratch[i5] = docIds[i5 + start] << 8;
                    }
                    for (i5 = 0; i5 < quarter; ++i5) {
                        int longIdx = i5 + numInts + start;
                        int n = i5;
                        this.scratch[n] = this.scratch[n] | docIds[longIdx] & 0xFF;
                        int n3 = i5 + quarter;
                        this.scratch[n3] = this.scratch[n3] | docIds[longIdx] >>> 8 & 0xFF;
                        int n4 = i5 + quarter * 2;
                        this.scratch[n4] = this.scratch[n4] | docIds[longIdx] >>> 16;
                    }
                    for (i5 = 0; i5 < numInts; ++i5) {
                        out.writeInt(this.scratch[i5]);
                    }
                    for (i5 = quarter << 2; i5 < count; ++i5) {
                        out.writeShort((short)docIds[start + i5]);
                        out.writeByte((byte)(docIds[start + i5] >>> 16));
                    }
                }
            } else {
                out.writeByte((byte)32);
                for (i = 0; i < count; ++i) {
                    out.writeInt(docIds[start + i]);
                }
            }
        }
    }

    private static void writeScalarInts24(int[] docIds, int start, int count, DataOutput out) throws IOException {
        int i;
        for (i = 0; i < count - 7; i += 8) {
            int doc1 = docIds[start + i];
            int doc2 = docIds[start + i + 1];
            int doc3 = docIds[start + i + 2];
            int doc4 = docIds[start + i + 3];
            int doc5 = docIds[start + i + 4];
            int doc6 = docIds[start + i + 5];
            int doc7 = docIds[start + i + 6];
            int doc8 = docIds[start + i + 7];
            long l1 = ((long)doc1 & 0xFFFFFFL) << 40 | ((long)doc2 & 0xFFFFFFL) << 16 | (long)(doc3 >>> 8) & 0xFFFFL;
            long l2 = ((long)doc3 & 0xFFL) << 56 | ((long)doc4 & 0xFFFFFFL) << 32 | ((long)doc5 & 0xFFFFFFL) << 8 | (long)(doc6 >> 16) & 0xFFL;
            long l3 = ((long)doc6 & 0xFFFFL) << 48 | ((long)doc7 & 0xFFFFFFL) << 24 | (long)doc8 & 0xFFFFFFL;
            out.writeLong(l1);
            out.writeLong(l2);
            out.writeLong(l3);
        }
        while (i < count) {
            out.writeShort((short)(docIds[start + i] >>> 8));
            out.writeByte((byte)docIds[start + i]);
            ++i;
        }
    }

    private static void writeIdsAsBitSet(int[] docIds, int start, int count, DataOutput out) throws IOException {
        int min2 = docIds[start];
        int max2 = docIds[start + count - 1];
        int offsetWords = min2 >> 6;
        int offsetBits = offsetWords << 6;
        int totalWordCount = FixedBitSet.bits2words(max2 - offsetBits + 1);
        long currentWord = 0L;
        int currentWordIndex = 0;
        out.writeVInt(offsetWords);
        out.writeVInt(totalWordCount);
        for (int i = 0; i < count; ++i) {
            int index = docIds[start + i] - offsetBits;
            int nextWordIndex = index >> 6;
            assert (currentWordIndex <= nextWordIndex);
            if (currentWordIndex < nextWordIndex) {
                out.writeLong(currentWord);
                currentWord = 0L;
                ++currentWordIndex;
                while (currentWordIndex < nextWordIndex) {
                    ++currentWordIndex;
                    out.writeLong(0L);
                }
            }
            currentWord |= 1L << index;
        }
        out.writeLong(currentWord);
        assert (currentWordIndex + 1 == totalWordCount);
    }

    void readInts(IndexInput in, int count, int[] docIDs) throws IOException {
        byte bpv = in.readByte();
        switch (bpv) {
            case -2: {
                DocIdsWriter.readContinuousIds(in, count, docIDs);
                break;
            }
            case -1: {
                this.readBitSet(in, count, docIDs);
                break;
            }
            case 16: {
                DocIdsWriter.readDelta16(in, count, docIDs);
                break;
            }
            case 21: {
                this.readInts21(in, count, docIDs);
                break;
            }
            case 24: {
                if (this.version < 10) {
                    DocIdsWriter.readScalarInts24(in, count, docIDs);
                    break;
                }
                this.readInts24(in, count, docIDs);
                break;
            }
            case 32: {
                DocIdsWriter.readInts32(in, count, docIDs);
                break;
            }
            case 0: {
                DocIdsWriter.readLegacyDeltaVInts(in, count, docIDs);
                break;
            }
            default: {
                throw new IOException("Unsupported number of bits per value: " + bpv);
            }
        }
    }

    private DocIdSetIterator readBitSetIterator(IndexInput in, int count) throws IOException {
        int offsetWords = in.readVInt();
        int longLen = in.readVInt();
        this.scratchLongs.longs = ArrayUtil.growNoCopy(this.scratchLongs.longs, longLen);
        in.readLongs(this.scratchLongs.longs, 0, longLen);
        if (longLen < this.scratchLongs.length) {
            Arrays.fill(this.scratchLongs.longs, longLen, this.scratchLongs.longs.length, 0L);
        }
        this.scratchLongs.length = longLen;
        FixedBitSet bitSet = new FixedBitSet(this.scratchLongs.longs, longLen << 6);
        return new DocBaseBitSetIterator(bitSet, count, offsetWords << 6);
    }

    private static void readContinuousIds(IndexInput in, int count, int[] docIDs) throws IOException {
        int start = in.readVInt();
        for (int i = 0; i < count; ++i) {
            docIDs[i] = start + i;
        }
    }

    private static void readLegacyDeltaVInts(IndexInput in, int count, int[] docIDs) throws IOException {
        int doc = 0;
        for (int i = 0; i < count; ++i) {
            docIDs[i] = doc += in.readVInt();
        }
    }

    private void readBitSet(IndexInput in, int count, int[] docIDs) throws IOException {
        int docId;
        DocIdSetIterator iterator = this.readBitSetIterator(in, count);
        int pos = 0;
        while ((docId = iterator.nextDoc()) != Integer.MAX_VALUE) {
            docIDs[pos++] = docId;
        }
        assert (pos == count) : "pos: " + pos + ", count: " + count;
    }

    private static void readDelta16(IndexInput in, int count, int[] docIds) throws IOException {
        int min2 = in.readVInt();
        int half = count >> 1;
        in.readInts(docIds, 0, half);
        if (count == 512) {
            DocIdsWriter.decode16(docIds, 256, min2);
        } else {
            DocIdsWriter.decode16(docIds, half, min2);
        }
        for (int i = half << 1; i < count; ++i) {
            docIds[i] = Short.toUnsignedInt(in.readShort()) + min2;
        }
    }

    private static void decode16(int[] docIDs, int half, int min2) {
        for (int i = 0; i < half; ++i) {
            int l = docIDs[i];
            docIDs[i] = (l >>> 16) + min2;
            docIDs[i + half] = (l & 0xFFFF) + min2;
        }
    }

    private static int floorToMultipleOf16(int n) {
        assert (n >= 0);
        return n & 0xFFFFFFF0;
    }

    private void readInts21(IndexInput in, int count, int[] docIDs) throws IOException {
        int i;
        int oneThird = DocIdsWriter.floorToMultipleOf16(count / 3);
        int numInts = oneThird << 1;
        in.readInts(this.scratch, 0, numInts);
        if (count == 512) {
            DocIdsWriter.decode21(docIDs, this.scratch, DocIdsWriter.floorToMultipleOf16(170), DocIdsWriter.floorToMultipleOf16(170) * 2);
        } else {
            DocIdsWriter.decode21(docIDs, this.scratch, oneThird, numInts);
        }
        for (i = oneThird * 3; i < count - 2; i += 3) {
            long l = in.readLong();
            docIDs[i] = (int)(l & 0x1FFFFFL);
            docIDs[i + 1] = (int)(l >>> 21 & 0x1FFFFFL);
            docIDs[i + 2] = (int)(l >>> 42);
        }
        while (i < count) {
            docIDs[i] = in.readShort() & 0xFFFF | (in.readByte() & 0xFF) << 16;
            ++i;
        }
    }

    private static void decode21(int[] docIds, int[] scratch, int oneThird, int numInts) {
        int i;
        for (i = 0; i < numInts; ++i) {
            docIds[i] = scratch[i] >>> 11;
        }
        for (i = 0; i < oneThird; ++i) {
            docIds[i + numInts] = scratch[i] & 0x7FF | (scratch[i + oneThird] & 0x7FF) << 11;
        }
    }

    private void readInts24(IndexInput in, int count, int[] docIDs) throws IOException {
        int quarter = count >> 2;
        int numInts = quarter * 3;
        in.readInts(this.scratch, 0, numInts);
        if (count == 512) {
            assert (DocIdsWriter.floorToMultipleOf16(quarter) == quarter) : "We are relying on the fact that quarter of BKDConfig.DEFAULT_MAX_POINTS_IN_LEAF_NODE is a multiple of 16 to vectorize the decoding loop, please check performance issue if you want to break this assumption.";
            DocIdsWriter.decode24(docIDs, this.scratch, 128, 384);
        } else {
            DocIdsWriter.decode24(docIDs, this.scratch, quarter, numInts);
        }
        for (int i = quarter << 2; i < count; ++i) {
            docIDs[i] = in.readShort() & 0xFFFF | (in.readByte() & 0xFF) << 16;
        }
    }

    private static void decode24(int[] docIDs, int[] scratch, int quarter, int numInts) {
        int i;
        for (i = 0; i < numInts; ++i) {
            docIDs[i] = scratch[i] >>> 8;
        }
        for (i = 0; i < quarter; ++i) {
            docIDs[i + numInts] = scratch[i] & 0xFF | (scratch[i + quarter] & 0xFF) << 8 | (scratch[i + quarter * 2] & 0xFF) << 16;
        }
    }

    private static void readScalarInts24(IndexInput in, int count, int[] docIDs) throws IOException {
        int i;
        for (i = 0; i < count - 7; i += 8) {
            long l1 = in.readLong();
            long l2 = in.readLong();
            long l3 = in.readLong();
            docIDs[i] = (int)(l1 >>> 40);
            docIDs[i + 1] = (int)(l1 >>> 16) & 0xFFFFFF;
            docIDs[i + 2] = (int)((l1 & 0xFFFFL) << 8 | l2 >>> 56);
            docIDs[i + 3] = (int)(l2 >>> 32) & 0xFFFFFF;
            docIDs[i + 4] = (int)(l2 >>> 8) & 0xFFFFFF;
            docIDs[i + 5] = (int)((l2 & 0xFFL) << 16 | l3 >>> 48);
            docIDs[i + 6] = (int)(l3 >>> 24) & 0xFFFFFF;
            docIDs[i + 7] = (int)l3 & 0xFFFFFF;
        }
        while (i < count) {
            docIDs[i] = Short.toUnsignedInt(in.readShort()) << 8 | Byte.toUnsignedInt(in.readByte());
            ++i;
        }
    }

    private static void readInts32(IndexInput in, int count, int[] docIDs) throws IOException {
        in.readInts(docIDs, 0, count);
    }

    void readInts(IndexInput in, int count, PointValues.IntersectVisitor visitor, int[] buffer) throws IOException {
        byte bpv = in.readByte();
        switch (bpv) {
            case -2: {
                DocIdsWriter.readContinuousIds(in, count, visitor);
                break;
            }
            case -1: {
                this.readBitSet(in, count, visitor);
                break;
            }
            case 16: {
                this.readDelta16(in, count, visitor);
                break;
            }
            case 21: {
                this.readInts21(in, count, visitor, buffer);
                break;
            }
            case 24: {
                if (this.version < 10) {
                    this.readScalarInts24(in, count, visitor);
                    break;
                }
                this.readInts24(in, count, visitor, buffer);
                break;
            }
            case 32: {
                this.readInts32(in, count, visitor);
                break;
            }
            case 0: {
                DocIdsWriter.readLegacyDeltaVInts(in, count, visitor);
                break;
            }
            default: {
                throw new IOException("Unsupported number of bits per value: " + bpv);
            }
        }
    }

    private void readBitSet(IndexInput in, int count, PointValues.IntersectVisitor visitor) throws IOException {
        DocIdSetIterator bitSetIterator = this.readBitSetIterator(in, count);
        visitor.visit(bitSetIterator);
    }

    private static void readContinuousIds(IndexInput in, int count, PointValues.IntersectVisitor visitor) throws IOException {
        int start = in.readVInt();
        visitor.visit(DocIdSetIterator.range(start, start + count));
    }

    private static void readLegacyDeltaVInts(IndexInput in, int count, PointValues.IntersectVisitor visitor) throws IOException {
        int doc = 0;
        for (int i = 0; i < count; ++i) {
            visitor.visit(doc += in.readVInt());
        }
    }

    private void readDelta16(IndexInput in, int count, PointValues.IntersectVisitor visitor) throws IOException {
        DocIdsWriter.readDelta16(in, count, this.scratch);
        this.scratchIntsRef.ints = this.scratch;
        this.scratchIntsRef.length = count;
        visitor.visit(this.scratchIntsRef);
    }

    private void readInts21(IndexInput in, int count, PointValues.IntersectVisitor visitor, int[] buffer) throws IOException {
        this.readInts21(in, count, buffer);
        this.scratchIntsRef.ints = buffer;
        this.scratchIntsRef.length = count;
        visitor.visit(this.scratchIntsRef);
    }

    private void readInts24(IndexInput in, int count, PointValues.IntersectVisitor visitor, int[] buffer) throws IOException {
        this.readInts24(in, count, buffer);
        this.scratchIntsRef.ints = buffer;
        this.scratchIntsRef.length = count;
        visitor.visit(this.scratchIntsRef);
    }

    private void readScalarInts24(IndexInput in, int count, PointValues.IntersectVisitor visitor) throws IOException {
        DocIdsWriter.readScalarInts24(in, count, this.scratch);
        this.scratchIntsRef.ints = this.scratch;
        this.scratchIntsRef.length = count;
        visitor.visit(this.scratchIntsRef);
    }

    private void readInts32(IndexInput in, int count, PointValues.IntersectVisitor visitor) throws IOException {
        in.readInts(this.scratch, 0, count);
        this.scratchIntsRef.ints = this.scratch;
        this.scratchIntsRef.length = count;
        visitor.visit(this.scratchIntsRef);
    }
}

