/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rfc3986.cmd;

import org.apache.jena.rfc3986.IRI3986;
import org.apache.jena.rfc3986.IRIParseException;
import org.apache.jena.rfc3986.RFC3986;

class CmdBase {
    CmdBase() {
    }

    protected static IRI3986 createOrExit(String iriStr, String errMsg) {
        try {
            return RFC3986.create(iriStr);
        }
        catch (IRIParseException ex) {
            System.err.println(errMsg + " IRI: " + ex.getMessage());
            System.exit(1);
            return null;
        }
    }

    protected static void print(IRI3986 iri2) {
        if (iri2 == null) {
            return;
        }
        try {
            System.out.print("  ");
            System.out.printf("%s|%s|  ", "Scheme", iri2.scheme());
            System.out.printf("%s|%s|  ", "Authority", iri2.authority());
            System.out.printf("%s|%s|  ", "Path", iri2.path());
            System.out.printf("%s|%s|  ", "Query", iri2.query());
            System.out.printf("%s|%s|", "Fragment", iri2.fragment());
            System.out.println();
            if (iri2.hasViolations()) {
                iri2.forEachViolation(v -> {
                    System.out.println();
                    System.err.println("Scheme specific error:");
                    System.err.println("    " + v.message());
                });
            }
        }
        catch (IRIParseException ex) {
            System.err.println(ex.getMessage());
        }
    }

    static String fixup(String iriStr) {
        if (iriStr.startsWith("<") && iriStr.endsWith(">")) {
            iriStr = iriStr.substring(1, iriStr.length() - 1);
        }
        return iriStr;
    }
}

