/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.build;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.JA;
import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.auth.Auth;
import org.apache.jena.fuseki.auth.AuthPolicy;
import org.apache.jena.fuseki.auth.AuthPolicyList;
import org.apache.jena.fuseki.build.BuildLib;
import org.apache.jena.fuseki.build.DatasetDescriptionMap;
import org.apache.jena.fuseki.build.FusekiExt;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.Endpoint;
import org.apache.jena.fuseki.server.FusekiVocabG;
import org.apache.jena.fuseki.server.Operation;
import org.apache.jena.fuseki.servlets.ActionService;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParserRegistry;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sparql.core.assembler.NamedDatasetAssembler;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.system.G;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;

public class FusekiConfig {
    private static Logger log = Fuseki.configLog;
    private static Map<String, Operation> stdRead = Map.of("sparql", Operation.Query, "query", Operation.Query, "data", Operation.GSP_R, "get", Operation.GSP_R);
    private static Map<String, Operation> stdWrite = Map.of("sparql", Operation.Query, "query", Operation.Query, "update", Operation.Update, "data", Operation.GSP_RW, "get", Operation.GSP_R, "patch", Operation.Patch);
    private static Set<Operation> stdDatasetRead = Set.of(Operation.Query, Operation.GSP_R);
    private static Set<Operation> stdDatasetWrite = Set.of(Operation.Query, Operation.Update, Operation.GSP_RW, Operation.Patch);

    public static DataService.Builder populateStdServices(DataService.Builder dataServiceBuilder, boolean allowUpdate) {
        HashSet endpoints = new HashSet();
        if (allowUpdate) {
            stdWrite.forEach((name, op) -> FusekiConfig.accEndpoint(endpoints, op, name));
            stdDatasetWrite.forEach(op -> FusekiConfig.accEndpoint(endpoints, op));
        } else {
            stdRead.forEach((name, op) -> FusekiConfig.accEndpoint(endpoints, op, name));
            stdDatasetRead.forEach(op -> FusekiConfig.accEndpoint(endpoints, op));
            if (FusekiExt.extraOperationServicesRead != null) {
                FusekiExt.extraOperationServicesRead.forEach((name, op) -> FusekiConfig.accEndpoint(endpoints, op, name));
            }
        }
        endpoints.forEach(dataServiceBuilder::addEndpoint);
        return dataServiceBuilder;
    }

    public static DataService buildDataServiceStd(DatasetGraph dsg, boolean withUpdate) {
        return DataService.newBuilder(dsg).withStdServices(withUpdate).build();
    }

    public static void removeDataset(DataAccessPointRegistry dataAccessPoints, String name) {
        name = DataAccessPoint.canonical(name);
        dataAccessPoints.remove(name);
    }

    @Deprecated
    public static AuthPolicy allowedUsers(Resource server) {
        return FusekiConfig.allowedUsers(server.getModel().getGraph(), server.asNode());
    }

    public static AuthPolicy allowedUsers(Graph graph, Node resource) {
        if (resource == null) {
            return null;
        }
        Collection<Node> allowedUsers = BuildLib.getMultiple(graph, resource, FusekiVocabG.pAllowedUsers);
        if (allowedUsers == null) {
            return null;
        }
        List bad = allowedUsers.stream().filter(rn -> !Util.isSimpleString(rn)).map(rn -> rn.toString()).collect(Collectors.toList());
        if (!bad.isEmpty()) {
            throw new FusekiConfigException(String.format("User names should be a simple string: bad = %s", bad));
        }
        Collection userNames = allowedUsers.stream().map(Node::getLiteralLexicalForm).collect(Collectors.toList());
        return Auth.policyAllowSpecific(userNames);
    }

    public static List<DataAccessPoint> processServerConfiguration(Graph configuration, Context context2) {
        Node server = FusekiConfig.findServer(configuration);
        if (server != null) {
            Resource rServer = FusekiConfig.resource(configuration, server);
            FusekiConfig.mergeContext(configuration, server, context2);
            FusekiConfig.processLoadClass(configuration, server);
        }
        return FusekiConfig.servicesAndDatasets$(configuration, server);
    }

    public static List<DataAccessPoint> processServerConfiguration(Model configuration, Context context2) {
        return FusekiConfig.processServerConfiguration(configuration.getGraph(), context2);
    }

    static Resource resource(Graph graph, Node node) {
        Model m = ModelFactory.createModelForGraph(graph);
        RDFNode rNode = m.asRDFNode(node);
        if (!rNode.isResource()) {
            throw new FusekiConfigException("Not a resource: " + String.valueOf(node));
        }
        return rNode.asResource();
    }

    @Deprecated
    public static Resource findServer(Model model) {
        Node server = FusekiConfig.findServer(model.getGraph());
        if (server == null) {
            return null;
        }
        return FusekiConfig.resource(model.getGraph(), server);
    }

    public static Node findServer(Graph graph) {
        List<Node> servers = G.nodesOfTypeAsList(graph, FusekiVocabG.tServer);
        if (servers.size() == 0) {
            return null;
        }
        if (servers.size() > 1) {
            throw new FusekiConfigException(servers.size() + " servers found (must be exactly one in a configuration file)");
        }
        Node server = servers.get(0);
        return server;
    }

    private static Context parseContext(Graph configuration, Node resource) {
        if (resource == null) {
            return null;
        }
        Resource r = FusekiConfig.resource(configuration, resource);
        return AssemblerUtils.parseContext(r);
    }

    private static void mergeContext(Graph configuration, Node resource, Context context2) {
        if (resource == null) {
            return;
        }
        Resource r = FusekiConfig.resource(configuration, resource);
        AssemblerUtils.mergeContext(r, context2);
    }

    public static void processLoadClass(Graph configuration, Node server) {
        if (server == null) {
            return;
        }
        List<Node> x = G.listSP(configuration, server, JA.loadClass.asNode());
        for (Node rn : x) {
            String className = null;
            if (rn.isBlank()) {
                log.warn("Blank node for class to load");
                continue;
            }
            if (rn.isURI()) {
                String javaScheme;
                String uri = rn.getURI();
                if (!uri.startsWith(javaScheme = "java:")) {
                    log.warn("Class to load is not 'java:': " + uri);
                    continue;
                }
                className = uri.substring(javaScheme.length());
            } else if (G.isString(rn)) {
                className = rn.getLiteralLexicalForm();
            }
            if (className == null) {
                throw new FusekiConfigException("Not a class name: " + BuildLib.displayStr(configuration, rn));
            }
            FusekiConfig.loadAndInit(className);
        }
    }

    public static List<DataAccessPoint> servicesAndDatasets(Graph graph) {
        Node server = FusekiConfig.findServer(graph);
        return FusekiConfig.servicesAndDatasets$(graph, server);
    }

    @Deprecated
    public static List<DataAccessPoint> servicesAndDatasets(Model model) {
        return FusekiConfig.servicesAndDatasets(model.getGraph());
    }

    private static List<DataAccessPoint> servicesAndDatasets$(Graph configuration, Node server) {
        DatasetDescriptionMap dsDescMap = new DatasetDescriptionMap();
        NamedDatasetAssembler.sharedDatasetPool.clear();
        RowSet rs = BuildLib.query("SELECT * { ?s fu:services [ list:member ?service ] }", configuration, "s", server);
        if (!rs.hasNext()) {
            rs = BuildLib.query("SELECT ?service { ?service a fu:Service }", configuration);
        }
        List<Node> services = rs.stream().map(b -> b.get("service")).toList();
        ArrayList<DataAccessPoint> accessPoints = new ArrayList<DataAccessPoint>();
        for (Node svc : services) {
            DataAccessPoint acc = FusekiConfig.buildDataAccessPoint(configuration, svc, dsDescMap);
            if (acc == null) continue;
            accessPoints.add(acc);
        }
        return accessPoints;
    }

    private static void loadAndInit(String className) {
        try {
            Class<?> classObj = Class.forName(className);
            log.info("Loaded " + className);
            Method initMethod = classObj.getMethod("init", new Class[0]);
            initMethod.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException ex) {
            log.warn("Class not found: " + className);
        }
        catch (Exception e2) {
            throw new FusekiConfigException(e2);
        }
    }

    private static Model readAssemblerFile(String filename) {
        return AssemblerUtils.readAssemblerFile(filename);
    }

    public static List<DataAccessPoint> readConfigurationDirectory(String dir) {
        Path pDir = Path.of(dir, new String[0]).normalize();
        File dirFile = pDir.toFile();
        if (!dirFile.exists()) {
            log.warn("Not found: directory for assembler files for services: '" + dir + "'");
            return Collections.emptyList();
        }
        if (!dirFile.isDirectory()) {
            log.warn("Not a directory: '" + dir + "'");
            return Collections.emptyList();
        }
        DirectoryStream.Filter<Path> filter = entry -> {
            File f = entry.toFile();
            Lang lang = RDFLanguages.filenameToLang(f.getName());
            return !f.isHidden() && f.isFile() && lang != null && RDFParserRegistry.isRegistered(lang);
        };
        ArrayList<DataAccessPoint> dataServiceRef = new ArrayList<DataAccessPoint>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(pDir, filter);){
            for (Path p : stream) {
                DatasetDescriptionMap dsDescMap = new DatasetDescriptionMap();
                String fn = IRILib.filenameToIRI(p.toString());
                log.info("Load configuration: " + fn);
                Graph m = FusekiConfig.readAssemblerFile(fn).getGraph();
                FusekiConfig.readConfiguration(m, dsDescMap, dataServiceRef);
            }
        }
        catch (IOException ex) {
            log.warn("IOException:" + ex.getMessage(), ex);
        }
        return dataServiceRef;
    }

    private static void readConfiguration(Graph configuration, DatasetDescriptionMap dsDescMap, List<DataAccessPoint> dataServiceRef) {
        List<Node> services = G.nodesOfTypeAsList(configuration, FusekiVocabG.fusekiService);
        if (services.size() == 0) {
            log.error("No services found");
            throw new FusekiConfigException();
        }
        for (Node service : services) {
            DataAccessPoint acc = FusekiConfig.buildDataAccessPoint(configuration, service, dsDescMap);
            if (acc == null) continue;
            dataServiceRef.add(acc);
        }
    }

    @Deprecated
    public static DataAccessPoint buildDataAccessPoint(Resource svc, DatasetDescriptionMap dsDescMap) {
        return FusekiConfig.buildDataAccessPoint(svc.getModel().getGraph(), svc.asNode(), dsDescMap);
    }

    public static DataAccessPoint buildDataAccessPoint(Graph configuration, Node fusekiService, DatasetDescriptionMap dsDescMap) {
        Node n = BuildLib.getOne(configuration, fusekiService, FusekiVocabG.pServiceName);
        try {
            if (!n.isLiteral()) {
                throw new FusekiConfigException("Not a literal for access point name: " + BuildLib.displayStr(configuration, n));
            }
            if (!Util.isSimpleString(n)) {
                Fuseki.configLog.error(String.format("Service name '%s' is not a string", BuildLib.strForResource(configuration, n)));
            }
            String name = n.getLiteralLexicalForm();
            name = DataAccessPoint.canonical(name);
            AuthPolicy allowedUsers = FusekiConfig.allowedUsers(configuration, fusekiService);
            DataService dataService = FusekiConfig.buildDataService(configuration, fusekiService, dsDescMap).setAuthPolicy(allowedUsers).build();
            DataAccessPoint dataAccess = new DataAccessPoint(name, dataService);
            return dataAccess;
        }
        catch (FusekiException ex) {
            Fuseki.configLog.error("Skipping: Failed to build service for " + BuildLib.displayStr(configuration, n));
            Fuseki.configLog.error("    " + ex.getMessage(), ex);
            return null;
        }
    }

    private static DataService.Builder buildDataService(Graph configuration, Node fusekiService, DatasetDescriptionMap dsDescMap) {
        Node datasetDesc = BuildLib.getOne(configuration, fusekiService, FusekiVocabG.pDataset);
        DatasetGraph dsg = FusekiConfig.getDataset(configuration, datasetDesc, dsDescMap);
        DataService.Builder dataService = DataService.newBuilder(dsg);
        HashSet<Endpoint> endpoints1 = new HashSet<Endpoint>();
        HashSet<Endpoint> endpoints2 = new HashSet<Endpoint>();
        FusekiConfig.accEndpointOldStyle(endpoints1, Operation.Query, configuration, fusekiService, FusekiVocabG.pServiceQueryEP);
        FusekiConfig.accEndpointOldStyle(endpoints1, Operation.Update, configuration, fusekiService, FusekiVocabG.pServiceUpdateEP);
        FusekiConfig.accEndpointOldStyle(endpoints1, Operation.GSP_R, configuration, fusekiService, FusekiVocabG.pServiceReadGraphStoreEP);
        FusekiConfig.accEndpointOldStyle(endpoints1, Operation.GSP_RW, configuration, fusekiService, FusekiVocabG.pServiceReadWriteGraphStoreEP);
        Collection<Endpoint> endpointsCompat = FusekiConfig.oldStyleCompat(dataService, endpoints1);
        endpointsCompat.forEach(dataService::addEndpoint);
        endpoints1.forEach(dataService::addEndpoint);
        FusekiConfig.accFusekiEndpoints(endpoints2, configuration, fusekiService, dsDescMap);
        endpoints2.forEach(dataService::addEndpoint);
        return dataService;
    }

    private static Collection<Endpoint> oldStyleCompat(DataService.Builder dataService, Set<Endpoint> endpoints1) {
        HashMap endpoints3 = new HashMap();
        endpoints1.forEach(ep -> {
            Operation operation = ep.getOperation();
            AuthPolicy auth = ep.getAuthPolicy();
            if (!StringUtils.isEmpty(ep.getName())) {
                if (endpoints3.containsKey(operation)) {
                    Endpoint ep1 = (Endpoint)endpoints3.get(operation);
                    auth = AuthPolicyList.merge(ep1.getAuthPolicy(), auth);
                    Endpoint ep2 = Endpoint.create(ep.getOperation(), "", auth);
                    endpoints3.put(operation, ep2);
                } else {
                    Endpoint ep2 = Endpoint.create(operation, "", auth);
                    endpoints3.put(operation, ep2);
                }
            }
        });
        endpoints1.stream().filter(ep -> StringUtils.isEmpty(ep.getName())).forEach(ep -> endpoints3.remove(ep.getOperation()));
        return endpoints3.values();
    }

    private static void accFusekiEndpoints(Set<Endpoint> endpoints, Graph configuration, Node fusekiService, DatasetDescriptionMap dsDescMap) {
        List<Node> endpointsDesc = G.listSP(configuration, fusekiService, FusekiVocabG.pEndpoint);
        endpointsDesc.forEach(ep -> {
            if (!G.isResource(ep)) {
                throw new FusekiConfigException("Literal for fuseki:endpoint: expected blank node or resource: " + BuildLib.displayStr(configuration, fusekiService));
            }
            Endpoint endpoint = FusekiConfig.buildEndpoint(configuration, fusekiService, ep);
            endpoints.add(endpoint);
        });
    }

    private static Endpoint buildEndpoint(Graph configuration, Node fusekiService, Node endpoint) {
        String epName;
        Node opRef = BuildLib.getOne(configuration, endpoint, FusekiVocabG.pOperation);
        Operation op = null;
        if (opRef != null) {
            if (G.isBlank(opRef)) {
                throw FusekiConfig.exception("Blank node endpoint operation in service %s", BuildLib.displayStr(configuration, fusekiService));
            }
            op = Operation.get(opRef);
        }
        if (op == null) {
            Node rImpl = BuildLib.getZeroOrOne(configuration, endpoint, FusekiVocabG.pImplementation);
            if (rImpl == null) {
                throw FusekiConfig.exception("No implementation for fuseki:operation '%s' in service %s", BuildLib.displayStr(configuration, opRef), BuildLib.displayStr(configuration, fusekiService));
            }
            Pair<Operation, ActionService> x = BuildLib.loadOperationActionService(configuration, rImpl);
            Operation op2 = x.getLeft();
            ActionService proc = x.getRight();
            if (op2 == null) {
                throw FusekiConfig.exception("Failed to load implementation for fuseki:operation '%s' in service %s", BuildLib.displayStr(configuration, opRef), BuildLib.displayStr(configuration, fusekiService));
            }
            op = op2;
        }
        AuthPolicy authPolicy = FusekiConfig.allowedUsers(configuration, endpoint);
        Node epNameN = BuildLib.getZeroOrOne(configuration, endpoint, FusekiVocabG.pEndpointName);
        if (epNameN == null) {
            epName = Endpoint.DatasetEP.string;
        } else {
            if (!G.isString(epNameN)) {
                throw FusekiConfig.exception("Not a literal for service name for endpoint", fusekiService, endpoint, FusekiVocabG.pEndpointName);
            }
            epName = epNameN.getLiteralLexicalForm();
        }
        Context cxt = FusekiConfig.parseContext(configuration, endpoint);
        Endpoint ep = Endpoint.create().operation(op).endpointName(epName).authPolicy(authPolicy).context(cxt).build();
        return ep;
    }

    private static FusekiConfigException exception(String fmt, Object ... args) {
        String msg = String.format(fmt, args);
        throw new FusekiConfigException(msg);
    }

    private static void accEndpointOldStyle(Collection<Endpoint> endpoints, Operation operation, Graph configuration, Node svc, Node endpointProperty) {
        List<Node> endPts = G.listSP(configuration, svc, endpointProperty);
        endPts.forEach(ep -> {
            AuthPolicy authPolicy = null;
            String endpointName = null;
            if (ep.isLiteral()) {
                endpointName = ep.getLiteralLexicalForm();
            } else {
                if (!G.isResource(ep)) throw new FusekiConfigException("Unrecognized: " + String.valueOf(ep));
                try {
                    List<Node> named = G.listSP(configuration, ep, FusekiVocabG.pEndpointName);
                    if (named.isEmpty()) {
                        throw new FusekiConfigException("Expected property <" + String.valueOf(FusekiVocabG.pEndpointName) + "> with <" + endpointProperty.getURI() + "> for " + BuildLib.displayStr(configuration, svc));
                    }
                    if (named.size() > 1) {
                        throw new FusekiConfigException("Multiple property values for <" + String.valueOf(FusekiVocabG.pEndpointName) + "> with <" + endpointProperty.getURI() + "> for " + BuildLib.displayStr(configuration, svc));
                    }
                    endpointName = named.get(0).getLiteralLexicalForm();
                    List<Node> x = G.listSP(configuration, ep, FusekiVocabG.pAllowedUsers);
                    if (x.size() > 1) {
                        throw new FusekiConfigException("Multiple fuseki:" + FusekiVocabG.pAllowedUsers.getLocalName() + " for " + BuildLib.displayStr(configuration, ep));
                    }
                    if (!x.isEmpty()) {
                        authPolicy = FusekiConfig.allowedUsers(configuration, ep);
                    }
                }
                catch (ClassCastException | JenaException ex) {
                    throw new FusekiConfigException("Failed to parse endpoint: " + BuildLib.displayStr(configuration, ep));
                }
            }
            if (StringUtils.isEmpty(endpointName)) {
                endpointName = null;
            }
            Endpoint endpoint = Endpoint.create(operation, endpointName, authPolicy);
            endpoints.add(endpoint);
        });
    }

    private static void accEndpoint(Collection<Endpoint> endpoints, Operation operation) {
        FusekiConfig.accEndpoint(endpoints, operation, null);
    }

    private static void accEndpoint(Collection<Endpoint> endpoints, Operation operation, String endpointName) {
        FusekiConfig.accEndpoint(endpoints, operation, endpointName, null);
    }

    private static void accEndpoint(Collection<Endpoint> endpoints, Operation operation, String endpointName, AuthPolicy authPolicy) {
        if (StringUtils.isEmpty(endpointName)) {
            endpointName = null;
        }
        Endpoint endpoint = Endpoint.create(operation, endpointName, authPolicy);
        endpoints.add(endpoint);
    }

    public static DatasetGraph getDataset(Graph configuration, Node datasetDesc, DatasetDescriptionMap dsDescMap) {
        DatasetGraph dsg = dsDescMap.get(datasetDesc);
        if (dsg != null) {
            return dsg;
        }
        if (!G.hasProperty(configuration, datasetDesc, RDF.Nodes.type)) {
            throw new FusekiConfigException("No rdf:type for dataset " + BuildLib.displayStr(configuration, datasetDesc));
        }
        Resource r = FusekiConfig.resource(configuration, datasetDesc);
        Dataset ds = (Dataset)Assembler.general().open(r);
        if (ds == null) {
            throw new FusekiConfigException("Bad description of a dataset: " + BuildLib.displayStr(configuration, datasetDesc));
        }
        dsg = ds.asDatasetGraph();
        dsDescMap.register(datasetDesc, dsg);
        return dsg;
    }
}

