/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfpatch.filelog.rotate;

import java.nio.file.Path;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.jena.rdfpatch.filelog.rotate.FileMgr;
import org.apache.jena.rdfpatch.filelog.rotate.Filename;
import org.apache.jena.rdfpatch.filelog.rotate.Roller;

class RollerIndex
implements Roller {
    private final Path directory;
    private final String baseFilename;
    private final String indexFormat;
    private Path lastFilename;
    public static Comparator<Filename> cmpNumericModifier = FileMgr.cmpNumericModifier;
    private final Pattern patternFilenameIndex = Pattern.compile("(.*)(" + Pattern.quote(".") + ")(\\d+)");
    private final String fmtModifer = "%04d";
    private static final String INC_SEP = ".";
    private Long currentId = null;
    private boolean inSection = false;

    RollerIndex(Path directory, String baseFilename, String indexFormat) {
        this.directory = directory;
        this.baseFilename = baseFilename;
        this.indexFormat = indexFormat;
        this.init(directory, baseFilename);
    }

    private void init(Path directory, String baseFilename) {
        List<Filename> filenames = FileMgr.scan(directory, baseFilename, this.patternFilenameIndex);
        if (!filenames.isEmpty()) {
            Filename max = Collections.max(filenames, cmpNumericModifier);
            this.currentId = Long.parseLong(max.modifier);
            this.lastFilename = this.filename(this.currentId);
        } else {
            this.currentId = 0L;
            this.lastFilename = null;
        }
    }

    @Override
    public Stream<Filename> files() {
        List<Filename> filenames = FileMgr.scan(this.directory, this.baseFilename, this.patternFilenameIndex);
        return filenames.stream().sorted(cmpNumericModifier);
    }

    @Override
    public Path directory() {
        return this.directory;
    }

    @Override
    public void startSection() {
        this.inSection = true;
    }

    @Override
    public void finishSection() {
        this.inSection = false;
    }

    @Override
    public Path latestFilename() {
        return this.lastFilename;
    }

    @Override
    public void rotate() {
    }

    @Override
    public boolean hasExpired() {
        return true;
    }

    private long nextIndex() {
        return this.currentId + 1L;
    }

    @Override
    public Path nextFilename() {
        long idx = this.nextIndex();
        this.currentId = idx;
        this.lastFilename = this.filename(this.currentId);
        return this.lastFilename;
    }

    private Path filename(Long idx) {
        Objects.requireNonNull(idx);
        String fn = FileMgr.basename(this.baseFilename, idx, INC_SEP, "%04d");
        return this.directory.resolve(fn);
    }
}

