/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.systemview.view;

import java.util.ArrayList;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.binary.BinarySchema;
import org.apache.ignite.internal.managers.systemview.walker.Order;
import org.apache.ignite.internal.util.typedef.internal.U;

public class BinaryMetadataView {
    private final BinaryMetadata meta;

    public BinaryMetadataView(BinaryMetadata meta) {
        this.meta = meta;
    }

    @Order
    public int typeId() {
        return this.meta.typeId();
    }

    @Order(value=1)
    public String typeName() {
        return this.meta.typeName();
    }

    @Order(value=2)
    public String affKeyFieldName() {
        return this.meta.affinityKeyFieldName();
    }

    @Order(value=3)
    public int fieldsCount() {
        return this.meta.fields().size();
    }

    @Order(value=4)
    public String fields() {
        return U.toStringSafe(this.meta.fields());
    }

    @Order(value=5)
    public String schemasIds() {
        ArrayList<Integer> ids = new ArrayList<Integer>(this.meta.schemas().size());
        for (BinarySchema schema : this.meta.schemas()) {
            ids.add(schema.schemaId());
        }
        return U.toStringSafe(ids);
    }

    @Order(value=6)
    public boolean isEnum() {
        return this.meta.isEnum();
    }
}

